CREATE TABLE IF NOT EXISTS dx_sandbox.daily_web_extension_viewer_funnel_helper_view (
  dt                                  TIMESTAMP WITHOUT TIME ZONE sortkey
  , channel_id                        BIGINT
  , extension_id                      VARCHAR(32)
  , extension_anchor                  VARCHAR(32)
  , device_id                         VARCHAR(32)
  , platform                          VARCHAR(40)
  , action                            VARCHAR(6)
);

CREATE TEMP TABLE temp_table (LIKE dx_sandbox.daily_web_extension_viewer_funnel_helper_view);

PREPARE the_delete_function_daily_web_extension_viewer_funnel_helper_view (BIGINT) AS
DELETE FROM dx_sandbox.daily_web_extension_viewer_funnel_helper_view
WHERE dt = DATEADD(day, $1, DATE_TRUNC('day', (SYSDATE - INTERVAL '7 hours')));

PREPARE the_insert_function_daily_web_extension_viewer_funnel_helper_view (BIGINT) AS
INSERT INTO temp_table (
  WITH the_parameter_constants AS (
    SELECT
      DATEADD(day, $1, DATE_TRUNC('day', (SYSDATE - INTERVAL '7 hours'))) as start_day,
      DATEADD(day, $1, DATE_TRUNC('day', (SYSDATE - INTERVAL '7 hours'))) + interval '1 day' as end_day
  )

  SELECT
  date_trunc('day',time) as dt
  ,v.channel_id
  ,v.extension_id
  ,v.extension_anchor
  ,v.device_id
  ,v.platform
  ,'view' as action
  FROM tahoe.extension_view v
  JOIN dx_sandbox.daily_web_extension_viewer_funnel_helper_render r on v.time >= r.dt and v.time < r.dt + interval '1 day'
                          and r.device_id = v.device_id
                          and r.extension_id = v.extension_id
                          and r.channel_id = v.channel_id
                          and r.extension_anchor = v.extension_anchor
  WHERE
  v.extension_anchor != 'NULL_EXTENSION_ANCHOR'
  and v.extension_anchor is not null
  and v.extension_anchor = 'panel'
  and v.date >= (SELECT start_day FROM the_parameter_constants)
  and v.date < (SELECT end_day FROM the_parameter_constants)
  and v.extension_mode not in ('dashboard', 'config')

  UNION

  SELECT
    dt,
    channel_id,
    extension_id,
    extension_anchor,
    device_id,
    platform,
    'view' as action
    FROM dx_sandbox.daily_web_extension_viewer_funnel_helper_render
    WHERE extension_anchor in ('component', 'video_overlay')
);

---
EXECUTE the_delete_function_daily_web_extension_viewer_funnel_helper_view(-4);
EXECUTE the_insert_function_daily_web_extension_viewer_funnel_helper_view(-4);
INSERT INTO dx_sandbox.daily_web_extension_viewer_funnel_helper_view
  (SELECT * FROM temp_table);
DELETE FROM temp_table;

EXECUTE the_delete_function_daily_web_extension_viewer_funnel_helper_view(-3);
EXECUTE the_insert_function_daily_web_extension_viewer_funnel_helper_view(-3);
INSERT INTO dx_sandbox.daily_web_extension_viewer_funnel_helper_view
  (SELECT * FROM temp_table);
DELETE FROM temp_table;

EXECUTE the_delete_function_daily_web_extension_viewer_funnel_helper_view(-2);
EXECUTE the_insert_function_daily_web_extension_viewer_funnel_helper_view(-2);
INSERT INTO dx_sandbox.daily_web_extension_viewer_funnel_helper_view
  (SELECT * FROM temp_table);
DELETE FROM temp_table;

EXECUTE the_delete_function_daily_web_extension_viewer_funnel_helper_view(-1);
EXECUTE the_insert_function_daily_web_extension_viewer_funnel_helper_view(-1);
INSERT INTO dx_sandbox.daily_web_extension_viewer_funnel_helper_view
  (SELECT * FROM temp_table);
DELETE FROM temp_table;

DEALLOCATE the_delete_function_daily_web_extension_viewer_funnel_helper_view;
DEALLOCATE the_insert_function_daily_web_extension_viewer_funnel_helper_view;
