DROP TABLE IF EXISTS the_temp_table; -- just in case there's a duplicate named table called "the_temp_table" since we often reuse this name
CREATE TEMP TABLE the_temp_table (LIKE dx_sandbox.extensions_metadata_helper_all_version_state);

INSERT INTO the_temp_table (



WITH
odd_even_series AS (
  SELECT n AS odd, n+1 AS even
  FROM dx_metadata.number_series
  WHERE n >= 1 AND n%2 = 1
)

-- use regex to parse out the extension version and state
, extension_version_state as (
  SELECT  odd, even, id, releasedversion, versionstates, deleted
    , regexp_substr(versionstates, '[0-9a-z._]+', 1, num.odd) as version   --- UPDATE REGEX STRING MANUALLY HERE CANNOT USE CTE ---
    , regexp_substr(versionstates, '[0-9a-z._]+', 1, num.even) as state   --- UPDATE REGEX STRING MANUALLY HERE CANNOT USE CTE ---
  FROM dbsnapshots.extensions_extension_summaries, odd_even_series as num
  WHERE
    even <= REGEXP_COUNT(versionstates, '[0-9a-z._]+')   --- UPDATE REGEX STRING MANUALLY HERE CANNOT USE CTE ---

)


-- rearrange and only keep the things we need
, the_final_data AS (
  SELECT
    id::VARCHAR(32) AS extension_id
    , version::VARCHAR(100) AS extension_version
    , state::VARCHAR(50)  AS extension_state
    , deleted::BOOLEAN AS bool_deleted
    , releasedversion::VARCHAR(100) AS recent_released_version
  FROM extension_version_state
)

SELECT (SELECT      DATEADD('day', -1,  DATE_TRUNC('day', (SYSDATE - INTERVAL '7 hours'))  )      )::DATE AS the_day, *
FROM the_final_data




);




DELETE FROM dx_sandbox.extensions_metadata_helper_all_version_state
WHERE the_day = DATEADD('day', -1,  DATE_TRUNC('day', (SYSDATE - INTERVAL '7 hours'))  )
;



INSERT INTO dx_sandbox.extensions_metadata_helper_all_version_state (
  SELECT * FROM the_temp_table
);

