-- tahoe.pageview


-- --  Create the table, define fields
-- CREATE TABLE dx_rollup.daily_mods_user_list (
--     the_day                     TIMESTAMP WITHOUT TIME ZONE sortkey
--     , user_id                   BIGINT
--     , flag_desklight_laguna     VARCHAR
-- );

--THEN CREATE A the_temp_table BASED ON THAT SCHEMA
CREATE TEMP TABLE the_temp_table (LIKE dx_rollup.daily_mods_user_list);

PREPARE the_insert_function_daily_mods_user_list (BIGINT) AS
INSERT INTO the_temp_table (

with

the_dates as (
  SELECT DATEADD(day, $1, DATE_TRUNC('day', (SYSDATE - INTERVAL '7 hours'))) as end_day
)
-- this is not needed as a dependency on the first line since after 2019-05-20 there is no more new data
, laguna_ids AS(
  SELECT DISTINCT date as the_day, user_id, 'laguna' as flag_desklight_laguna
  FROM tahoe.curse_app_pageview
  WHERE split_part(path, '/', 2) IN ('addons',
  'minecraft')
  AND date = (select end_day from the_dates)
)

, desklight_ids AS (
  SELECT DISTINCT date as the_day, user_id, 'desklight' as flag_desklight_laguna
  FROM tahoe.pageview
  WHERE platform = 'desktop'
  AND location LIKE 'desklight/mods%'
  AND location != 'desklight/mods/games-available'
  AND date = (select end_day from the_dates)
)

, final as (
  select * from laguna_ids
  union all
  select * from desklight_ids
)

select * from final
);


PREPARE the_delete_function_daily_mods_user_list (BIGINT) AS
DELETE FROM dx_rollup.daily_mods_user_list
WHERE dx_rollup.daily_mods_user_list.the_day = DATEADD(day, $1, DATE_TRUNC('day', (SYSDATE - INTERVAL '7 hours')))
;

--RUN THE STUFF
EXECUTE the_insert_function_daily_mods_user_list (-4);
EXECUTE the_delete_function_daily_mods_user_list (-4);
INSERT INTO dx_rollup.daily_mods_user_list (SELECT * FROM the_temp_table); DELETE FROM the_temp_table;

EXECUTE the_insert_function_daily_mods_user_list (-3);
EXECUTE the_delete_function_daily_mods_user_list (-3);
INSERT INTO dx_rollup.daily_mods_user_list (SELECT * FROM the_temp_table); DELETE FROM the_temp_table;

EXECUTE the_insert_function_daily_mods_user_list (-2);
EXECUTE the_delete_function_daily_mods_user_list (-2);
INSERT INTO dx_rollup.daily_mods_user_list (SELECT * FROM the_temp_table);
DELETE FROM the_temp_table;


EXECUTE the_insert_function_daily_mods_user_list (-1);
EXECUTE the_delete_function_daily_mods_user_list (-1);
INSERT INTO dx_rollup.daily_mods_user_list (SELECT * FROM the_temp_table);
DELETE FROM the_temp_table;




-- DEALLOCATE THE INSERT FUNCTION
DEALLOCATE the_insert_function_daily_mods_user_list;
DEALLOCATE the_delete_function_daily_mods_user_list;
