
DROP TABLE IF EXISTS dx_sandbox.edcp_helper_all_install_records_parsed_part2;

CREATE TABLE dx_sandbox.edcp_helper_all_install_records_parsed_part2 AS

WITH

the_logs AS (
  SELECT id::BIGINT AS channel_id, installs AS installs_json
  FROM dbsnapshots.extensions_channel_extensions
  WHERE
    installs IS NOT NULL
    AND id IS NOT NULL
    AND f_is_numeric(id) = TRUE
)

, smaller_number_series AS (
  SELECT n
  FROM dx_metadata.number_series
  WHERE n>=1 AND n<=(SELECT MAX(install_record) FROM dx_sandbox.edcp_helper_all_install_records_parsed_part1)
)

, cross_join_logs_number_series AS (
  SELECT channel_id, installs_json, n
  FROM the_logs
  CROSS JOIN smaller_number_series
)

SELECT * FROM cross_join_logs_number_series;

