-- DROP TABLE IF EXISTS  dx_sandbox.ninety_day_extension_activations;
--
-- CREATE TABLE dx_sandbox.ninety_day_extension_activations (
--     date                    TIMESTAMP WITHOUT TIME ZONE sortkey
--     , activation_time        TIMESTAMP
--     , channel_id                  BIGINT
--     , extension_id              VARCHAR distkey
-- );

--THEN CREATE A the_temp_table BASED ON THAT SCHEMA
CREATE TEMP TABLE the_temp_table (LIKE dx_sandbox.ninety_day_extension_activations);

PREPARE the_insert_function (int) AS
INSERT INTO the_temp_table (
with

dates as (
  select DATEADD(day, $1, DATE_TRUNC('day', (SYSDATE - INTERVAL '7 hours'))) as end_day,
  (DATEADD(day, $1, DATE_TRUNC('day', (SYSDATE - INTERVAL '7 hours'))) - INTERVAL '90 days') as start_day

)

, activations as (
select DATEADD(day, $1, DATE_TRUNC('day', (SYSDATE - INTERVAL '7 hours'))) as date,
max(time) as the_time, channel_id, extension_id, 'activated' as action
from spade.extension_activate
where extension_dynamic_managed = FALSE
and date >= (select start_day from dates)
and date <= (select end_day from dates)
group by 1, 3, 4, 5
)

, deactivations as (
select DATEADD(day, $1, DATE_TRUNC('day', (SYSDATE - INTERVAL '7 hours'))) as date,
max(time) as the_time, channel_id, extension_id, 'deactivated' as action
from spade.extension_deactivate
where extension_dynamic_managed = FALSE
and date >= (select start_day from dates)
and date <= (select end_day from dates)
group by 1, 3, 4, 5
union
select DATEADD(day, $1, DATE_TRUNC('day', (SYSDATE - INTERVAL '7 hours'))) as date,
max(time) as the_time, channel_id, extension_id, 'uninstalled' as action
from spade.extension_uninstall
where
date >= (select start_day from dates)
and date <= (select end_day from dates)
group by 1, 3, 4, 5
)

, final as (
select a.*
, case when b.the_time >= a.the_time then 'deactivated'
else 'activated' end as final_state
from activations as a
left join deactivations as b
on a.channel_id = b.channel_id
and a.extension_id = b.extension_id
and a.date = b.date
)

select
date,
the_time as activation_time,
channel_id,
extension_id
from final
where final_state = 'activated'

);

PREPARE the_delete_function (int) AS
DELETE FROM dx_sandbox.ninety_day_extension_activations
WHERE dx_sandbox.ninety_day_extension_activations.date = DATEADD(day, $1, DATE_TRUNC('day', (SYSDATE - INTERVAL '7 hours')))
;

EXECUTE the_insert_function(-4);
EXECUTE the_delete_function(-4);
INSERT INTO dx_sandbox.ninety_day_extension_activations  (SELECT * FROM the_temp_table);
DELETE FROM the_temp_table;

EXECUTE the_insert_function(-3);
EXECUTE the_delete_function(-3);
INSERT INTO dx_sandbox.ninety_day_extension_activations  (SELECT * FROM the_temp_table);
DELETE FROM the_temp_table;

EXECUTE the_insert_function(-2);
EXECUTE the_delete_function(-2);
INSERT INTO dx_sandbox.ninety_day_extension_activations  (SELECT * FROM the_temp_table);
DELETE FROM the_temp_table;

EXECUTE the_insert_function(-1);
EXECUTE the_delete_function(-1);
INSERT INTO dx_sandbox.ninety_day_extension_activations  (SELECT * FROM the_temp_table);
DELETE FROM the_temp_table;


DEALLOCATE the_insert_function;
DEALLOCATE the_delete_function;
