--NOTE: SPEC FOR ---> dx_rollup.daily_top_games_stats
-- the_day
-- game_full_name
-- game_flattened
-- is_non_gaming
-- is_gaming
-- mw_rank
-- mw_total
-- mb_total
-- dav_of_game
-- das_of_game


-- CHANGE the_index_date IF YOU WANT TO CHANGE THE RELATIVE DATE
CREATE TEMP TABLE the_dates_table AS (
  SELECT DATE_TRUNC('day', (SYSDATE - INTERVAL '7 hours'))::DATE AS the_index_date --today's start date
);



-- create temp table that's a fixed lookup table for game names from warehouse.dim_game
CREATE TEMP TABLE the_constants_game AS (
  SELECT MAX(name) AS game_full_name, name_minimized AS game_flattened, BOOL_AND(is_non_gaming) AS is_non_gaming
  FROM warehouse.dim_game
  -- these are a list of bad games to not include in the lookup
  -- 461368 is "AR-K" which duplicates "ARK"
  WHERE id NOT IN (461368)
  ---- Star Wars Battlefront II has two ids since the name has colon and non colon versions
  -- so group by game and name_minimized
  GROUP BY name_minimized
);

--DELETE THE DATA FOR THE DAY YOU ARE GOING TO BE ADDING IN
PREPARE the_delete_function_daily_top_games_stats (BIGINT) AS
DELETE FROM dx_rollup.daily_top_games_stats
WHERE the_day = DATEADD(  'day', $1, (SELECT the_index_date FROM the_dates_table)  )
;



--THEN CREATE A the_temp_table BASED ON THAT SCHEMA
CREATE TEMP TABLE the_temp_table (LIKE dx_rollup.daily_top_games_stats);

--THEN WRITE YOUR SQL CODE FOR THE INSERT FUNCTION
PREPARE the_insert_function_daily_top_games_stats (BIGINT) AS
INSERT INTO the_temp_table (



WITH

the_constants AS (
  SELECT 100::BIGINT AS top_x_rank -- get the top X games by mw per day
    , DATEADD('day', $1, the_index_date) AS start_date, DATEADD('day', $1+1, the_index_date) AS end_date
  FROM (SELECT the_index_date FROM the_dates_table)
)



, daily_mw_agg AS (
  SELECT day AS the_day, game_flattened, SUM(mw_total) AS mw_total
  FROM cubes.daily_minutes_watched_by_game
  WHERE (SELECT start_date FROM the_constants) <= day AND day <(SELECT end_date FROM the_constants)
  GROUP BY 1,2
)
, daily_mw_per_game AS (
  SELECT *
  FROM (
    SELECT the_day, game_flattened, DENSE_RANK() OVER (PARTITION BY the_day ORDER BY mw_total DESC) AS mw_rank, mw_total
    FROM daily_mw_agg
    WHERE game_flattened IS NOT NULL
    GROUP BY 1,2,4
  )
  WHERE mw_rank<=(SELECT top_x_rank FROM the_constants)
)

, daily_mb_per_game AS (
  SELECT day AS the_day, game_flattened, SUM(mb_total) AS mb_total
  FROM cubes.daily_minutes_broadcast_by_game
  WHERE (SELECT start_date FROM the_constants) <= day AND day <(SELECT end_date FROM the_constants)
  GROUP BY 1,2
)

--NOTE: spec for dx_rollup.active_viewer_of_game
-- the_day
-- platform
-- channel_id
-- game
-- game_flattened
-- user_id
-- device_id

-- we have data from 2019-01-12 onward
, dav_of_game AS (
  SELECT the_day, game_flattened, COUNT(DISTINCT device_id) AS dav_of_game
  FROM dx_rollup.active_viewer_of_game
  WHERE (SELECT start_date FROM the_constants) <= the_day AND the_day <(SELECT end_date FROM the_constants)
  GROUP BY 1,2
)


--NOTE: SPEC FOR ---> dx_rollup.active_streamer_of_game
-- the_day
-- rolling_7_day_start
-- rolling_7_day_end
-- game
-- game_flattened
-- channel_id
-- mb_of_game_rolling_7_day
-- is_active_streamer_of_game

-- we have data from 2019-10-04 onward

--NOTE: an "active streamer of a game" is true when you have streamed at least 30 minutes of the game in the recent 7 day period
--This is a definition we defined along with Adam Butterfoss (PM) as part of the League of Legends extension launch
, das_of_game AS (
  SELECT the_day, game_flattened, COUNT(DISTINCT channel_id) AS das_of_game
  FROM dx_rollup.active_streamer_of_game
  WHERE (SELECT start_date FROM the_constants) <= the_day AND the_day <(SELECT end_date FROM the_constants)
    AND is_active_streamer_of_game = TRUE
  GROUP BY 1,2
)


-- top 100
-- the_day, game_flattened, game_full_name, mw_rank, total mw (not just live), mb
--, dav of game, da streamers of game, is_game flag

, join_data AS (
  SELECT base.the_day::DATE, game_full_name::VARCHAR(500), base.game_flattened::VARCHAR(500), is_non_gaming::BOOLEAN
    , CASE WHEN is_non_gaming = FALSE THEN TRUE::BOOLEAN ELSE FALSE::BOOLEAN END AS is_gaming
    , mw_rank::BIGINT, mw_total::BIGINT, mb_total::BIGINT, dav_of_game::BIGINT, das_of_game::BIGINT
  FROM daily_mw_per_game AS base
  LEFT JOIN the_constants_game AS game_meta ON base.game_flattened = game_meta.game_flattened
  LEFT JOIN daily_mb_per_game AS mb ON base.the_day = mb.the_day AND base.game_flattened = mb.game_flattened
  LEFT JOIN dav_of_game AS dav ON base.the_day = dav.the_day AND base.game_flattened = dav.game_flattened
  LEFT JOIN das_of_game AS das ON base.the_day = das.the_day AND base.game_flattened = das.game_flattened
)

SELECT * FROM join_data ORDER BY the_day, mw_rank
);


EXECUTE the_insert_function_daily_top_games_stats (-1); EXECUTE the_delete_function_daily_top_games_stats (-1);   INSERT INTO dx_rollup.daily_top_games_stats    (SELECT * FROM the_temp_table);  DELETE FROM the_temp_table;
EXECUTE the_insert_function_daily_top_games_stats (-2); EXECUTE the_delete_function_daily_top_games_stats (-2);   INSERT INTO dx_rollup.daily_top_games_stats    (SELECT * FROM the_temp_table);  DELETE FROM the_temp_table;
EXECUTE the_insert_function_daily_top_games_stats (-3); EXECUTE the_delete_function_daily_top_games_stats (-3);   INSERT INTO dx_rollup.daily_top_games_stats    (SELECT * FROM the_temp_table);  DELETE FROM the_temp_table;
EXECUTE the_insert_function_daily_top_games_stats (-4); EXECUTE the_delete_function_daily_top_games_stats (-4);   INSERT INTO dx_rollup.daily_top_games_stats    (SELECT * FROM the_temp_table);  DELETE FROM the_temp_table;
EXECUTE the_insert_function_daily_top_games_stats (-5); EXECUTE the_delete_function_daily_top_games_stats (-5);   INSERT INTO dx_rollup.daily_top_games_stats    (SELECT * FROM the_temp_table);  DELETE FROM the_temp_table;


