--NOTE: SPEC FOR ---> dx_rollup.dev_hub_2020_daily_top_25_category_list
-- the_day
-- game_full_name
-- game_flattened
-- is_non_gaming
-- is_gaming
-- num_days_on_top_over_rolling_365


-- Increase the number of daily Top 25 categories for the prior year with a
--    strategic Twitch integration from 17% to 25%, an increase of 800 bps, by December 31, 2020.
-- Daily Top 25 categories includes any category with a daily rank across all categories of total HW
--    (not just live HW) between 1 - 25 for at least seven days in the prior year.

-- Metric defn here: https://docs.google.com/document/d/1o9eiqCVOTneLfAFG1SvHtv24sx4AE7MoPdh54GLUUv0/edit
-- Twitch integrations list here https://docs.google.com/spreadsheets/d/1nfYM_ZCC1kNtJv88d8z7Db8dtQfV5NzafbzMXbUn7Mw/edit#gid=0


-- CHANGE the_index_date IF YOU WANT TO CHANGE THE RELATIVE DATE
CREATE TEMP TABLE the_dates_table AS (
  SELECT DATE_TRUNC('day', (SYSDATE - INTERVAL '7 hours'))::DATE AS the_index_date --today's start date
);

CREATE TEMP TABLE the_params AS (
  SELECT 25::BIGINT AS top_x_category -- get the top 25 categories each day from dx_rollup.daily_top_games_stats
    , 7::BIGINT AS x_days_in_prior_year -- for at least seven days in the prior year
);






--DELETE THE DATA FOR THE DAY YOU ARE GOING TO BE ADDING IN
PREPARE the_delete_function (BIGINT) AS
DELETE FROM dx_rollup.dev_hub_2020_daily_top_25_category_list
WHERE the_day = DATEADD(  'day', $1, (SELECT the_index_date FROM the_dates_table)  )
;



--THEN CREATE A the_temp_table BASED ON THAT SCHEMA
CREATE TEMP TABLE the_temp_table (LIKE dx_rollup.dev_hub_2020_daily_top_25_category_list);

--THEN WRITE YOUR SQL CODE FOR THE INSERT FUNCTION
PREPARE the_insert_function (BIGINT) AS
INSERT INTO the_temp_table (



WITH

the_constants AS (
  SELECT (SELECT top_x_category FROM the_params) AS top_x_category
    , (SELECT x_days_in_prior_year FROM the_params) AS x_days_in_prior_year
    , DATEADD('day', $1-1, the_index_date) AS start_date_inclusive
    , DATEADD('day', $1, the_index_date) AS end_date_inclusive
  FROM (SELECT the_index_date FROM the_dates_table)
)
, log_daily_top_games_stats AS (
  SELECT the_day, mw_rank, game_full_name, game_flattened, is_non_gaming
    , is_gaming, mw_total, mb_total, dav_of_game, das_of_game
  FROM dx_rollup.daily_top_games_stats
  WHERE mw_rank<=25
    AND the_day>(SELECT DATEADD('day', -365, end_date_inclusive ) FROM the_constants)
    AND the_day<=(SELECT end_date_inclusive FROM the_constants)
)
, log_daily_top_25_list_denom AS (
  SELECT (SELECT end_date_inclusive FROM the_constants) AS the_day
    , game_full_name, game_flattened
    , is_non_gaming, is_gaming, COUNT(1) AS num_days_on_top_over_rolling_365
  FROM log_daily_top_games_stats
  GROUP BY 1,2,3,4,5
)

, final_data AS (
  SELECT *  FROM log_daily_top_25_list_denom
  WHERE num_days_on_top_over_rolling_365>=(SELECT x_days_in_prior_year FROM the_constants)
)


SELECT * FROM final_data

);


EXECUTE the_insert_function (-1); EXECUTE the_delete_function (-1);   INSERT INTO dx_rollup.dev_hub_2020_daily_top_25_category_list    (SELECT * FROM the_temp_table);  DELETE FROM the_temp_table;
EXECUTE the_insert_function (-2); EXECUTE the_delete_function (-2);   INSERT INTO dx_rollup.dev_hub_2020_daily_top_25_category_list    (SELECT * FROM the_temp_table);  DELETE FROM the_temp_table;
EXECUTE the_insert_function (-3); EXECUTE the_delete_function (-3);   INSERT INTO dx_rollup.dev_hub_2020_daily_top_25_category_list    (SELECT * FROM the_temp_table);  DELETE FROM the_temp_table;
EXECUTE the_insert_function (-4); EXECUTE the_delete_function (-4);   INSERT INTO dx_rollup.dev_hub_2020_daily_top_25_category_list    (SELECT * FROM the_temp_table);  DELETE FROM the_temp_table;
EXECUTE the_insert_function (-5); EXECUTE the_delete_function (-5);   INSERT INTO dx_rollup.dev_hub_2020_daily_top_25_category_list    (SELECT * FROM the_temp_table);  DELETE FROM the_temp_table;


