WITH start_and_end_times AS
(
  SELECT {start_day} AS start_time,
         {end_day} AS end_time
),
channels_with_first_broadcast_date AS
(
  SELECT channel_id,
         MIN(day) AS first_broadcast_date
  FROM cubes.daily_minutes_broadcast_by_channel
  GROUP BY 1
),
affiliate_partner_channels_first_status_date AS
(
  SELECT channel_id,
         MIN(effective_from_time) AS first_status_date
  FROM cubes.affiliate_partner_channel_status_timeline
  GROUP BY 1
),
affiliate_partner_channels_timeline_before_first_status_date AS
(
  SELECT apcfsd.channel_id,
         NULL AS affiliate_or_partner_status_type,
         cwmbd.first_broadcast_date AS effective_from_time,
         apcfsd.first_status_date AS effective_until_time
  FROM affiliate_partner_channels_first_status_date apcfsd
    INNER JOIN channels_with_first_broadcast_date cwmbd
            ON apcfsd.channel_id = cwmbd.channel_id
           AND cwmbd.first_broadcast_date < apcfsd.first_status_date
),
non_affiliate_non_partner_broadcaster_channels_timeline AS
(
  SELECT channel_id,
         NULL AS affiliate_or_partner_status_type,
         first_broadcast_date AS effective_from_time,
         SYSDATE AS effective_until_time
  FROM channels_with_first_broadcast_date
  WHERE channel_id NOT IN (SELECT channel_id FROM affiliate_partner_channels_first_status_date)
),
eligible_channels AS
(
  SELECT channel_id,
         affiliate_or_partner_status_type,
         effective_from_time,
         COALESCE(effective_until_time,SYSDATE) AS effective_until_time
  FROM cubes.affiliate_partner_channel_status_timeline
  UNION ALL
  SELECT channel_id,
         affiliate_or_partner_status_type,
         effective_from_time,
         effective_until_time
  FROM affiliate_partner_channels_timeline_before_first_status_date
  UNION ALL
  SELECT channel_id,
         affiliate_or_partner_status_type,
         effective_from_time,
         effective_until_time
  FROM non_affiliate_non_partner_broadcaster_channels_timeline
),
eligible_channel_renames AS
(
  SELECT "time" AS renamed_at,
         LEAD("time") OVER (PARTITION BY user_id ORDER BY "time") AS next_rename_at,
         user_id,
         old_login,
         new_login
  FROM spade.login_rename lr
  WHERE user_id IN (SELECT channel_id FROM eligible_channels GROUP BY 1)
),
day_channel_matrix AS
(
  SELECT d."date" AS day,
         ec.channel_id,
         CASE
           WHEN ecr.new_login IS NOT NULL THEN ecr.new_login
           WHEN ecr.new_login IS NULL AND LEAD(ecr.old_login) IGNORE NULLS OVER (PARTITION BY ec.channel_id ORDER BY d."date") IS NOT NULL THEN LEAD(ecr.old_login) IGNORE NULLS OVER (PARTITION BY ec.channel_id ORDER BY d."date")
           ELSE ue.login
         END AS channel,
         CASE
           WHEN affiliate_or_partner_status_type IN ('affiliate') THEN TRUE
           ELSE FALSE
         END AS is_affiliate,
         CASE
           WHEN affiliate_or_partner_status_type IN ('partner','0cpm_partner') THEN TRUE
           ELSE FALSE
         END AS is_partner,
         effective_from_time,
         effective_until_time
  FROM eligible_channels ec
    INNER JOIN metadata."date" d
            ON d."date" >= ec.effective_from_time
           AND d."date" < ec.effective_until_time
    LEFT JOIN eligible_channel_renames ecr
           ON ec.channel_id = ecr.user_id
          AND d."date" >= ecr.renamed_at
          AND (d."date" < ecr.next_rename_at
           OR ecr.next_rename_at IS NULL)
    LEFT JOIN cubes.users_enriched ue ON ec.channel_id = ue.user_id
  WHERE d."date" >= (SELECT start_time FROM start_and_end_times)
  AND   d."date" < (SELECT end_time FROM start_and_end_times)
),
