

--THEN CREATE A the_temp_table BASED ON THAT SCHEMA
CREATE TABLE IF NOT EXISTS dx_sandbox.extension_content_matched_metric_partial_premium (LIKE dx_rollup.extension_content_matched_metric);
CREATE TABLE IF NOT EXISTS dx_sandbox.extension_content_matched_metric_partial_ugc (LIKE dx_rollup.extension_content_matched_metric);



CREATE TABLE dx_sandbox.extension_cme_metric_helper_blessed_games
AS SELECT * FROM dx_sandbox.extension_content_matched_metric_blessed_games_list
;































--for every the_day and channel_id combination, there could be multiple extension_id
DROP TABLE IF EXISTS dx_sandbox.extension_cme_metric_helper_daily_blessed_extension_per_channel;
CREATE TABLE dx_sandbox.extension_cme_metric_helper_daily_blessed_extension_per_channel AS


  WITH

  the_constants_time AS (
    SELECT start_date, DATEADD(day, 1, start_date) AS end_date
    FROM (SELECT '2019-06-01'::DATE AS start_date)
  )

  --for ugc channels, get the "blessed" list of game to extension_id mapping
  --https://docs.google.com/spreadsheets/d/1hk7i3qeL63s4jxAItljN__2dejtzZCpMv4SHk3y6Dqs/edit#gid=738274537
  , first_party_extension_log AS (
    SELECT *, TRUE AS flag_is_ugc_content_matched_extension FROM dx_metadata.official_content_matched_extensions
    -- game_name	        VARCHAR(256)
    -- extension_id	      VARCHAR(256)
    -- extension_name	    VARCHAR(256)
    -- extension_url	    VARCHAR(256)
    -- game_flattened	    VARCHAR(256)
  )

  -- for premium channels, these are the extension_id to count towards content matched mw
  -- https://docs.google.com/spreadsheets/d/1hk7i3qeL63s4jxAItljN__2dejtzZCpMv4SHk3y6Dqs/edit#gid=0
  , blessed_premium_extensions AS (
    SELECT extension_id, extension_name, extension_url, flag_is_content_matched AS flag_is_premium_content_matched_extension
    FROM dx_sandbox.premium_channel_extensions
    WHERE flag_is_content_matched = TRUE
    GROUP BY 1,2,3,4
    -- extension_id	            VARCHAR(256)
    -- extension_name	          VARCHAR(256)
    -- extension_url	          VARCHAR(256)
    -- flag_is_content_matched	BOOL
  )

  , channel_daily_status AS (
    SELECT the_date, channel_id, tier, CASE WHEN tier IN ('T5: Premium') THEN 'O&O Channel' ELSE 'UGC Channel' END AS flag_ugc_oo_channel
    FROM dx_rollup.channel_daily_status
    WHERE
      (SELECT start_date FROM the_constants_time)<=the_date AND the_date<(SELECT end_date FROM the_constants_time)
  )

  --only take records where the extension is activated
  , extension_daily_channel_presence_log AS (
    SELECT base.the_day, base.channel_id, cds.flag_ugc_oo_channel, base.extension_id
    FROM dx_rollup.extension_daily_channel_presence AS base
    LEFT JOIN channel_daily_status AS cds ON base.channel_id = cds.channel_id AND base.the_day = cds.the_date
    WHERE
      (SELECT start_date FROM the_constants_time)<=the_day AND the_day<(SELECT end_date FROM the_constants_time)
      AND bool_extension_activated = TRUE
  )
  --join extension_daily_channel_presence with ugc and premium channel's extension metadata for CME tagging
  , extension_daily_channel_presence_log_step2 AS (
    SELECT base.the_day, base.channel_id, base.flag_ugc_oo_channel, base.extension_id
      , first_p.game_name, first_p.game_flattened
      , first_p.flag_is_ugc_content_matched_extension
      , bpe.flag_is_premium_content_matched_extension
    FROM extension_daily_channel_presence_log AS base
    LEFT JOIN first_party_extension_log AS first_p ON base.extension_id = first_p.extension_id
    LEFT JOIN blessed_premium_extensions AS bpe ON base.extension_id = bpe.extension_id
  )

  --only include records where the extensions are in the blessed list of extensions for ugc channels, or they are tier 5 (o&o) with the premium extensions
  , extension_daily_channel_presence_log_step3 AS (
    SELECT *
    FROM extension_daily_channel_presence_log_step2
    WHERE
      (flag_is_premium_content_matched_extension AND flag_ugc_oo_channel='O&O Channel') -- it is a premium channel, and it has a premium channel content matched extension
      OR
      (flag_is_ugc_content_matched_extension AND flag_ugc_oo_channel='UGC Channel') --it is not a premium channel, and it has a ugc channel content matched extension
  )

  --logic to determine if the extension should count various platform mins watched
  , extensions_metadata_log AS (
    SELECT *
      --if any of the conditions of enabled on overlay, panel or component is true, then count web as true, else false
      , CASE WHEN is_overlay_enabled OR is_panel_enabled OR is_component_enabled THEN true ELSE false END AS flag_count_web
      --if is_mobile_enabled is true THEN count android as true, else false
      , CASE WHEN is_mobile_enabled THEN true ELSE false END AS flag_count_android
      --need special logic for ios pending discussion with Danny Chi on extensions team, because ios needs special whitelist
      , false AS flag_count_ios
      ----------------------------------------------------------------------------------------------
      --ADJUST THIS WHEN OTHER PLATFORMS GET EXTENSION SUPPORT (i.e. CONSOLE OR DESKTOP APP)--------
      ----------------------------------------------------------------------------------------------
      --Desklight project will bring extensions onto the desktop app, official launch date still TBD
      , CASE WHEN (SELECT start_date FROM the_constants_time)>='3000-01-01' THEN true ELSE false END AS flag_count_desktop
      --for console, there are no current plans to support extensions
      , false AS flag_count_playstation
      , false AS flag_count_xboxone
      , false AS flag_count_xbox360
      --mobile web and chromecase and other are not slated to have extensions support
      , false AS flag_count_mobile_web
      , false AS flag_count_chromecast
      , false AS flag_count_other
      ----------------------------------------------------------------------------------------------
      ----------------------------------------------------------------------------------------------
    FROM dx_metadata.all_extensions_latest
  )


  --join the data, this has multiple rows per game_flattened since it can be 1 game multiple extensions
  , daily_blessed_extension_per_channel AS (
    SELECT base.the_day, base.channel_id, base.flag_ugc_oo_channel
      , base.extension_id::VARCHAR(32), base.game_name, base.game_flattened
      , ext_meta.extension_name::VARCHAR(MAX)
      , ext_meta.extension_url
      , ext_meta.extension_category_name
      , ext_meta.flag_count_web
      , ext_meta.flag_count_android
      , ext_meta.flag_count_ios
      , ext_meta.flag_count_desktop
      , ext_meta.flag_count_playstation
      , ext_meta.flag_count_xboxone
      , ext_meta.flag_count_xbox360
      , ext_meta.flag_count_mobile_web
      , ext_meta.flag_count_chromecast
      , ext_meta.flag_count_other
      , base.flag_is_ugc_content_matched_extension
      , base.flag_is_premium_content_matched_extension
    FROM extension_daily_channel_presence_log_step3 AS base
    LEFT JOIN extensions_metadata_log AS ext_meta ON base.extension_id = ext_meta.extension_id
  )


  --aggregate daily_blessed_extension_per_channel to be 1 row per the_day, channel_id, game_flattened
  , daily_blessed_extension_per_channel_step2 AS (
    SELECT
      the_day, channel_id, game_flattened
      , '['||the_extension_id_listagg::VARCHAR(65530)||']' AS the_extension_id_array
      , '['||the_extension_name_listagg::VARCHAR(65530)||']' AS the_extension_name_array
      , flag_count_web, flag_count_android, flag_count_ios, flag_count_desktop
      , flag_count_playstation, flag_count_xboxone, flag_count_xbox360
      , flag_count_mobile_web, flag_count_chromecast, flag_count_other
      , flag_is_ugc_content_matched_extension
      , flag_is_premium_content_matched_extension
    FROM (
      SELECT the_day, channel_id, game_flattened
      , listagg('"'||extension_id||'"', ',') WITHIN GROUP (ORDER BY extension_name) AS the_extension_id_listagg
      , listagg('"'||extension_name||'"', ',') WITHIN GROUP (ORDER BY extension_name) AS the_extension_name_listagg
      , BOOL_OR(flag_count_web) AS flag_count_web
      , BOOL_OR(flag_count_android) AS flag_count_android
      , BOOL_OR(flag_count_ios) AS flag_count_ios
      , BOOL_OR(flag_count_desktop) AS flag_count_desktop
      , BOOL_OR(flag_count_playstation) AS flag_count_playstation
      , BOOL_OR(flag_count_xboxone) AS flag_count_xboxone
      , BOOL_OR(flag_count_xbox360) AS flag_count_xbox360
      , BOOL_OR(flag_count_mobile_web) AS flag_count_mobile_web
      , BOOL_OR(flag_count_chromecast) AS flag_count_chromecast
      , BOOL_OR(flag_count_other) AS flag_count_other
      , BOOL_OR(flag_is_ugc_content_matched_extension) AS flag_is_ugc_content_matched_extension
      , BOOL_OR(flag_is_premium_content_matched_extension) AS flag_is_premium_content_matched_extension
      FROM daily_blessed_extension_per_channel
      GROUP BY 1,2,3
    )
  )

  , final_data AS (
    SELECT * FROM daily_blessed_extension_per_channel_step2
  )


  SELECT * FROM final_data

;



--DATA QA
WITH
the_dups AS (
  SELECT channel_id
  FROM (
    SELECT the_day, flag_ugc_oo_channel, channel_id, COUNT(1) AS rows
    FROM dx_sandbox.extension_cme_metric_helper_extension_daily_channel_presence_log

    GROUP BY 1,2,3
  )
  WHERE rows>1
)

SELECT * FROM dx_sandbox.extension_cme_metric_helper_extension_daily_channel_presence_log
WHERE channel_id IN (SELECT channel_id FROM the_dups)
AND flag_ugc_oo_channel='O&O Channel'
ORDER BY the_day, channel_id, extension_id;

SELECT * FROM dx_sandbox.extension_cme_metric_helper_extension_daily_channel_presence_log
WHERE flag_ugc_oo_channel='O&O Channel'
LIMIT 100;


SELECT the_day, channel_id, COUNT(1) AS rows, COUNT(DISTINCT extension_id) AS extensions
FROM dx_sandbox.extension_cme_metric_helper_extension_daily_channel_presence_log
WHERE flag_ugc_oo_channel='UGC Channel'
GROUP BY 1,2
ORDER BY 1,4 DESC
LIMIT 100
;
























DROP TABLE dx_sandbox.extension_cme_metric_helper_daily_hours_watched_per_channel_platform_game;
--get per channel hw stats
CREATE TABLE dx_sandbox.extension_cme_metric_helper_daily_hours_watched_per_channel_platform_game AS

WITH

the_constants_time AS (
  SELECT start_date, DATEADD(day, 1, start_date) AS end_date
  FROM (SELECT '2019-06-01'::DATE AS start_date)
)


  , daily_hours_watched_per_channel_platform_game AS (
    SELECT day AS the_day, channel_id, platform
      , regexp_replace(lower(game),'([^a-zA-Z0-9.])','') as game_flattened --anything that isn't alphanumeric replace with blank
      , SUM(mw::FLOAT/60) AS hw
    FROM cubes.hours_watched_daily_by_device
    WHERE
      (SELECT start_date FROM the_constants_time)<=day AND day<(SELECT end_date FROM the_constants_time)
      AND content_mode IN ('live stream')
    GROUP BY 1,2,3,4
  )

  , channel_daily_status AS (
    SELECT the_date, channel_id, tier
    FROM dx_rollup.channel_daily_status
    WHERE
      (SELECT start_date FROM the_constants_time)<=the_date AND the_date<(SELECT end_date FROM the_constants_time)
  )

  , final_data AS (
    SELECT base.the_day, base.channel_id, base.platform::VARCHAR(255), base.game_flattened::VARCHAR(MAX)
      , CASE WHEN cds.tier IN ('T5: Premium') THEN 'O&O Channel' ELSE 'UGC Channel' END AS flag_ugc_oo_channel
      -- , cds.flag_ugc_oo_channel::VARCHAR(32)
      , base.hw
    FROM daily_hours_watched_per_channel_platform_game AS base
    LEFT JOIN channel_daily_status AS cds ON base.channel_id = cds.channel_id AND base.the_day = cds.the_date
  )

  SELECT * FROM final_data

;



--DATA QA

SELECT the_day, flag_ugc_oo_channel, COUNT(1) AS rows, COUNT(DISTINCT channel_id) AS channels, SUM(hw)
FROM dx_sandbox.extension_cme_metric_helper_daily_hours_watched_per_channel_platform_game
GROUP BY 1,2
ORDER BY 1,2;
