--CAVEATS ON DATA
--for some users who never change their login, they have one record in logs.login_rename where old_login = new_login
-- i.e. chewiemelodies (67955580)
--for users who never change their login, potentially they won't have a record in logs.login_rename, so we have to use db_snapshots.users
-- i.e. a_dot_burr (155528531)

-- -- RUN THIS ON INITIAL CREATE TABLE
-- DROP TABLE IF EXISTS dx_metadata.user_id_to_login_mapping;
-- CREATE TABLE dx_metadata.user_id_to_login_mapping (
--   user_id	              BIGINT
--   , login               VARCHAR(255)
-- )
-- ;


-- RUN THIS FOR DAILY UPDATES AFTER INITIAL CREATION OF TABLE
DELETE FROM dx_metadata.user_id_to_login_mapping; --REMOVE OLD RECORDS
INSERT INTO dx_metadata.user_id_to_login_mapping (




WITH


--take all unique pairs of old_login and user_id in logs.login_rename
login_rename_old AS (
  SELECT user_id, old_login AS login
  FROM tahoe.login_rename
  GROUP BY 1,2
)

--take all unique pairs of new_login and user_id in logs.login_rename
, login_rename_new AS (
  SELECT user_id, new_login AS login
  FROM tahoe.login_rename
  GROUP BY 1,2
)

--take all unique pairs of login and id (user_id) in logs.login_rename db_snapshots.users
, dbsnap_users AS (
  SELECT id AS user_id, login
  FROM dbsnapshots.users
  GROUP BY 1,2
)

, union_records AS (
  SELECT * FROM dbsnap_users
  UNION ALL SELECT * FROM login_rename_new
  UNION ALL SELECT * FROM login_rename_old
)

, final_data AS (
  SELECT * FROM union_records GROUP BY 1,2
)

SELECT * FROM final_data
)
;
