// Gets the .sql code to upload the released extensions
// EXAMPLE USAGE
// node get_released_extensions_latest.js ./json/extension_logs_${i}.json 'sql'

var fs = require('fs');
var args = process.argv.slice(2); // Normalize arguments list see:  https://stackoverflow.com/questions/4351521/how-do-i-pass-command-line-arguments
var filename = args[0]; // The name of the json file you want to parse
var output_type = args[1]; // The output type, either sql or csv
var filename_extension = filename.slice(filename.length-4, filename.length);


const fn_extension_category = require('./fn_extension_category');



if (filename_extension=='json') {
  const str_union_all = '\r\n'+'UNION ALL';
  const single_quote = '\'';
  const double_quote = '\"';
  const bracket_open = '[';
  const bracket_close = ']';

  var the_json = JSON.parse(fs.readFileSync(filename, 'utf8'))['extensions'];
  var the_json_length = the_json.length;
  for (var i=0; i<the_json_length; i++) {
    var extension_state = the_json[i]['State'];
    var is_valid_extension=(extension_state!='Testing'&&extension_state!='Deprecated'&&extension_state!='Assets Uploaded'&&extension_state!='Deleted')?true:false;
    var is_released_extension=(extension_state=='Released')?true:false;
    var extension_anchor=the_json[i]['Anchor'];
    var extension_author_email=the_json[i]['AuthorEmail'];
    var extension_author_name=the_json[i]['AuthorName'].replace(/\'/g, '').replace(/\,/g, '');
    var extension_id=the_json[i]['ID'];
    var extension_name=the_json[i]['Name'].replace(/\'/g, '').replace(/\,/g, '');
    var extension_support_email=the_json[i]['SupportEmail'];
    var extension_version=the_json[i]['Version'];
    var extension_url='https://www.twitch.tv/ext/'+extension_id;
    var is_bits_enabled=the_json[i]['BitsEnabled'];
    var broadcaster_whitelist=the_json[i]['BroadcasterWhitelist'];
    var broadcaster_whitelist_valid_rs_json=[];
    if (broadcaster_whitelist !== null) {
      for (var x=0; x<broadcaster_whitelist.length; x++) {
        broadcaster_whitelist_valid_rs_json.push(double_quote+broadcaster_whitelist[x]+double_quote);
      }
    }
    var extension_category_id=the_json[i]['Categories'];
    var extension_category_name=fn_extension_category.convert_extension_category_id(extension_category_id);
    var component_viewer_path=the_json[i]['Views']['Component']['ViewerPath'];
    var overlay_viewer_path=the_json[i]['Views']['VideoOverlay']['ViewerPath'];
    var panel_viewer_path=the_json[i]['Views']['Panel']['ViewerPath'];
    var mobile_viewer_path=the_json[i]['Views']['Mobile']['ViewerPath'];
    var is_component_enabled=(component_viewer_path!='')?true:false;
    var is_overlay_enabled=(overlay_viewer_path!='')?true:false;
    var is_panel_enabled=(panel_viewer_path!='')?true:false;
    var is_mobile_enabled=(mobile_viewer_path!='')?true:false;
    var is_whitelisted_extension=(broadcaster_whitelist !== null && broadcaster_whitelist !== '')?true:false;
    var is_chat_enabled = the_json[i]['HasChatSupport'];



    if (is_released_extension){
      if (is_whitelisted_extension) {
        var whitelist_channels_str = (single_quote+bracket_open + broadcaster_whitelist_valid_rs_json + bracket_close+single_quote);
      } else {
        var whitelist_channels_str = 'NULL';
      }
      if (output_type == 'sql') {
        sql_line = 'SELECT '
          +single_quote + extension_id + single_quote + ' AS extension_id'
          +','+ single_quote + extension_version + single_quote + ' AS extension_version'
          +','+ single_quote + extension_category_id + single_quote + ' AS extension_category_id'
          +','+ single_quote + extension_category_name + single_quote + ' AS extension_category_name'
          +','+ single_quote + extension_name + single_quote + ' AS extension_name'
          +','+ single_quote + extension_anchor + single_quote + ' AS extension_anchor'
          +','+ single_quote + extension_author_email + single_quote + ' AS extension_author_email'
          +','+ single_quote + extension_author_name + single_quote + ' AS extension_author_name'
          +','+ single_quote + extension_support_email + single_quote + ' AS extension_support_email'
          +','+ single_quote + extension_url + single_quote + ' AS extension_url'
          +','+ is_bits_enabled + ' AS is_bits_enabled'
          +','+ is_component_enabled + ' AS is_component_enabled'
          +','+ is_overlay_enabled + ' AS is_overlay_enabled'
          +','+ is_panel_enabled + ' AS is_panel_enabled'
          +','+ is_mobile_enabled + ' AS is_mobile_enabled'
          +','+ is_chat_enabled + ' AS is_chat_enabled'
          +','+ is_whitelisted_extension + ' AS is_whitelisted_extension'
          +','+ whitelist_channels_str + ' AS whitelist_channels'
          + str_union_all
        ;
        console.log(sql_line);
      } else if (output_type == 'csv') {
        console.log(
          extension_id
          +','+ extension_version
          +','+ extension_category_id
          +','+ extension_category_name
          +','+ extension_name
          +','+ extension_anchor
          +','+ extension_author_email
          +','+ extension_author_name
          +','+ extension_support_email
          +','+ extension_url
          +','+ is_bits_enabled
          +','+ is_component_enabled
          +','+ is_overlay_enabled
          +','+ is_panel_enabled
          +','+ is_mobile_enabled
          +','+ is_chat_enabled
          +','+ is_whitelisted_extension
          +','+ whitelist_channels_str
        )
      }
    }
  }
}
