// Gets the .sql code to upload the released extensions
// EXAMPLE USAGE
// node get_released_extensions_latest.js ./json/extension_logs_${i}.json 'sql'

var fs = require('fs');
var moment = require('moment');
var args = process.argv.slice(2); // Normalize arguments list see:  https://stackoverflow.com/questions/4351521/how-do-i-pass-command-line-arguments
var filename = args[0]; // The name of the json file you want to parse
var output_type = args[1]; // The output type, either sql or csv
var filename_extension = filename.slice(filename.length-4, filename.length);

const fn_extension_category = require('./fn_extension_category');

// isInArray(1, [1,2,3]); // true
function isInArray(value, array) {
  return array.indexOf(value) > -1;
}

if (filename_extension=='json') {
  const str_union_all = '\r\n'+'UNION ALL';
  const single_quote = '\'';
  const double_quote = '\"';
  const bracket_open = '[';
  const bracket_close = ']';
  const csv_delimiter = '\%';

  var the_json = JSON.parse(fs.readFileSync(filename, 'utf8'))['extensions'];
  var the_json_length = the_json.length;
  var the_date = String(moment().subtract(7, 'hours').format("YYYY-MM-DD"));
  for (var i=0; i<the_json_length; i++) {
    var extension_state = the_json[i]['State'].substring(0, 65530);
    var extension_anchor=the_json[i]['Anchor'].substring(0, 65530);
    var extension_author_email=the_json[i]['AuthorEmail'].substring(0, 65530);
    var extension_author_name=the_json[i]['AuthorName'].replace(/\'/g, '').replace(/\,/g, '').replace(/\%/g, '').substring(0, 65530);
    var extension_id=the_json[i]['ID'].substring(0, 65530);
    var extension_name=the_json[i]['Name'].replace(/\'/g, '').replace(/\,/g, '').replace(/\%/g, '').substring(0, 65530);
    var extension_support_email=the_json[i]['SupportEmail'].substring(0, 65530);
    var extension_version=the_json[i]['Version'].substring(0, 65530);
    var extension_url='https://www.twitch.tv/ext/'+extension_id;
    var is_bits_enabled=the_json[i]['BitsEnabled'];
    var broadcaster_whitelist=the_json[i]['BroadcasterWhitelist'];
    var broadcaster_whitelist_valid_rs_json=[];
    if (broadcaster_whitelist !== null) {
      for (var x=0; x<broadcaster_whitelist.length; x++) {
        broadcaster_whitelist_valid_rs_json.push(double_quote+broadcaster_whitelist[x]+double_quote);
      }
    }
    var extension_category_id=the_json[i]['Categories'];
    var extension_category_name=fn_extension_category.convert_extension_category_id(extension_category_id);
    var component_viewer_path=the_json[i]['Views']['Component']['ViewerPath'];
    var overlay_viewer_path=the_json[i]['Views']['VideoOverlay']['ViewerPath'];
    var panel_viewer_path=the_json[i]['Views']['Panel']['ViewerPath'];
    var mobile_viewer_path=the_json[i]['Views']['Mobile']['ViewerPath'];
    var is_component_enabled=(component_viewer_path!='')?true:false;
    var is_overlay_enabled=(overlay_viewer_path!='')?true:false;
    var is_panel_enabled=(panel_viewer_path!='')?true:false;
    var is_mobile_enabled=(mobile_viewer_path!='')?true:false;
    var is_whitelisted_extension=(broadcaster_whitelist !== null && broadcaster_whitelist !== '')?true:false;
    var is_chat_enabled = the_json[i]['HasChatSupport'];




    if (is_whitelisted_extension) {
      var whitelist_channels_str = (single_quote+bracket_open + broadcaster_whitelist_valid_rs_json + bracket_close+single_quote);
    } else {
      var whitelist_channels_str = 'NULL';
    }
    if (output_type == 'sql') {
      sql_line = 'INSERT INTO the_temp_table ( SELECT '
        + 'DATE_TRUNC(\'day\', (SYSDATE - INTERVAL \'7 hours\'))' + ' AS the_date'
        +','+ single_quote + extension_id + single_quote + ' AS extension_id'
        +','+ single_quote + extension_version + single_quote + ' AS extension_version'
        +','+ single_quote + extension_state + single_quote + ' AS extension_state'
        +','+ single_quote + extension_category_id + single_quote + ' AS extension_category_id'
        +','+ single_quote + extension_category_name + single_quote + ' AS extension_category_name'
        +','+ single_quote + extension_name + single_quote + ' AS extension_name'
        +','+ single_quote + extension_anchor + single_quote + ' AS extension_anchor'
        +','+ single_quote + extension_author_email + single_quote + ' AS extension_author_email'
        +','+ single_quote + extension_author_name + single_quote + ' AS extension_author_name'
        +','+ single_quote + extension_support_email + single_quote + ' AS extension_support_email'
        +','+ single_quote + extension_url + single_quote + ' AS extension_url'
        +','+ is_bits_enabled + ' AS is_bits_enabled'
        +','+ is_component_enabled + ' AS is_component_enabled'
        +','+ is_overlay_enabled + ' AS is_overlay_enabled'
        +','+ is_panel_enabled + ' AS is_panel_enabled'
        +','+ is_mobile_enabled + ' AS is_mobile_enabled'
        +','+ is_chat_enabled + ' AS is_chat_enabled'
        +','+ is_whitelisted_extension + ' AS is_whitelisted_extension'
        +','+ whitelist_channels_str + ' AS whitelist_channels'
        + ');'
      ;
      console.log(sql_line);
    } else if (output_type == 'csv') {
      console.log(
        csv_delimiter + the_date + csv_delimiter
        +','+ csv_delimiter + extension_id + csv_delimiter
        +','+ csv_delimiter + extension_version + csv_delimiter
        +','+ csv_delimiter + extension_state + csv_delimiter
        +','+ csv_delimiter + extension_category_id + csv_delimiter
        +','+ csv_delimiter + extension_category_name + csv_delimiter
        +','+ csv_delimiter + extension_name + csv_delimiter
        +','+ csv_delimiter + extension_anchor + csv_delimiter
        +','+ csv_delimiter + extension_author_email + csv_delimiter
        +','+ csv_delimiter + extension_author_name + csv_delimiter
        +','+ csv_delimiter + extension_support_email + csv_delimiter
        +','+ csv_delimiter + extension_url + csv_delimiter
        +','+ csv_delimiter + is_bits_enabled + csv_delimiter
        +','+ csv_delimiter + is_component_enabled + csv_delimiter
        +','+ csv_delimiter + is_overlay_enabled + csv_delimiter
        +','+ csv_delimiter + is_panel_enabled + csv_delimiter
        +','+ csv_delimiter + is_mobile_enabled + csv_delimiter
        +','+ csv_delimiter + is_chat_enabled + csv_delimiter
        +','+ csv_delimiter + is_whitelisted_extension + csv_delimiter
        +','+ csv_delimiter + whitelist_channels_str + csv_delimiter
      )
    }
  }
}
