// Parse json blobs, and returns csv that feeds into dx_metadata.all_extensions_latest or dx_metadata.released_extensions_latest
// EXAMPLE USAGE
// node get_released_extensions_latest.js ./json/extension_logs_${i}.json 'all'

var fs = require('fs');
var moment = require('moment');
var args = process.argv.slice(2); // Normalize arguments list see:  https://stackoverflow.com/questions/4351521/how-do-i-pass-command-line-arguments
var filename = args[0]; // The name of the json file you want to parse
var flag_extension_list = args[1]; // 'all' or 'released'
var filename_extension = filename.slice(filename.length-4, filename.length);


const fn_extension_category = require('./fn_extension_category');
const str_union_all = '\r\n'+'UNION ALL';
const single_quote = '\'';
const double_quote = '\"';
const bracket_open = '[';
const bracket_close = ']';
const csv_delimiter = '\%';
const the_date = String(moment().subtract(7, 'hours').format("YYYY-MM-DD"));



if (filename_extension=='json') {
  const the_json = JSON.parse(fs.readFileSync(filename, 'utf8'))['extensions'];
  const the_json_length = the_json.length;


  for (var i=0; i<the_json_length; i++) {
    var extension_state = the_json[i]['State'].substring(0, 65530);;
    var is_released_extension=(extension_state=='Released')?true:false;
    var extension_anchor=the_json[i]['Anchor'].substring(0, 65530);
    var extension_author_email=the_json[i]['AuthorEmail'].substring(0, 65530);
    var extension_author_name=the_json[i]['AuthorName'].replace(/\'/g, '').replace(/\,/g, '').replace(/\%/g, '').substring(0, 65530);
    var extension_id=the_json[i]['ID'].substring(0, 65530);
    var extension_name=the_json[i]['Name'].replace(/\'/g, '').replace(/\,/g, '').replace(/\%/g, '').substring(0, 65530);
    var extension_support_email=the_json[i]['SupportEmail'].substring(0, 65530);
    var extension_version=the_json[i]['Version'].substring(0, 65530);
    var extension_url='https://www.twitch.tv/ext/'+extension_id;
    var is_bits_enabled=the_json[i]['BitsEnabled'];
    var broadcaster_whitelist=the_json[i]['BroadcasterWhitelist'];
    var broadcaster_whitelist_valid_rs_json=[];
    if (broadcaster_whitelist !== null) {
      for (var x=0; x<broadcaster_whitelist.length; x++) {
        broadcaster_whitelist_valid_rs_json.push(double_quote+broadcaster_whitelist[x]+double_quote);
      }
    }
    if (is_whitelisted_extension) {
      var whitelist_channels_str = (bracket_open + broadcaster_whitelist_valid_rs_json + bracket_close);
    } else {
      var whitelist_channels_str = 'NULL';
    }
    var extension_category_id=the_json[i]['Categories'];
    var extension_category_name=fn_extension_category.convert_extension_category_id(extension_category_id);
    var component_viewer_path=the_json[i]['Views']['Component']['ViewerPath'];
    var overlay_viewer_path=the_json[i]['Views']['VideoOverlay']['ViewerPath'];
    var panel_viewer_path=the_json[i]['Views']['Panel']['ViewerPath'];
    var mobile_viewer_path=the_json[i]['Views']['Mobile']['ViewerPath'];
    var is_component_enabled=(component_viewer_path!='')?true:false;
    var is_overlay_enabled=(overlay_viewer_path!='')?true:false;
    var is_panel_enabled=(panel_viewer_path!='')?true:false;
    var is_mobile_enabled=(mobile_viewer_path!='')?true:false;
    var is_whitelisted_extension=(broadcaster_whitelist !== null && broadcaster_whitelist !== '')?true:false;
    var is_chat_enabled = the_json[i]['HasChatSupport'];


    if (flag_extension_list=='released') {
      if (is_released_extension){
        console.log(
          csv_delimiter + extension_id + csv_delimiter
          +','+ csv_delimiter + extension_version + csv_delimiter
          +','+ csv_delimiter + extension_category_id + csv_delimiter
          +','+ csv_delimiter + extension_category_name + csv_delimiter
          +','+ csv_delimiter + extension_name + csv_delimiter
          +','+ csv_delimiter + extension_anchor + csv_delimiter
          +','+ csv_delimiter + extension_author_email + csv_delimiter
          +','+ csv_delimiter + extension_author_name + csv_delimiter
          +','+ csv_delimiter + extension_support_email + csv_delimiter
          +','+ csv_delimiter + extension_url + csv_delimiter
          +','+ csv_delimiter + is_bits_enabled + csv_delimiter
          +','+ csv_delimiter + is_component_enabled + csv_delimiter
          +','+ csv_delimiter + is_overlay_enabled + csv_delimiter
          +','+ csv_delimiter + is_panel_enabled + csv_delimiter
          +','+ csv_delimiter + is_mobile_enabled + csv_delimiter
          +','+ csv_delimiter + is_chat_enabled + csv_delimiter
          +','+ csv_delimiter + is_whitelisted_extension + csv_delimiter
          +','+ csv_delimiter + whitelist_channels_str + csv_delimiter
        )
      }
    } else if (flag_extension_list=='all') {
      console.log(
        csv_delimiter + the_date + csv_delimiter
        +','+ csv_delimiter + extension_id + csv_delimiter
        +','+ csv_delimiter + extension_version + csv_delimiter
        +','+ csv_delimiter + extension_state + csv_delimiter
        +','+ csv_delimiter + extension_category_id + csv_delimiter
        +','+ csv_delimiter + extension_category_name + csv_delimiter
        +','+ csv_delimiter + extension_name + csv_delimiter
        +','+ csv_delimiter + extension_anchor + csv_delimiter
        +','+ csv_delimiter + extension_author_email + csv_delimiter
        +','+ csv_delimiter + extension_author_name + csv_delimiter
        +','+ csv_delimiter + extension_support_email + csv_delimiter
        +','+ csv_delimiter + extension_url + csv_delimiter
        +','+ csv_delimiter + is_bits_enabled + csv_delimiter
        +','+ csv_delimiter + is_component_enabled + csv_delimiter
        +','+ csv_delimiter + is_overlay_enabled + csv_delimiter
        +','+ csv_delimiter + is_panel_enabled + csv_delimiter
        +','+ csv_delimiter + is_mobile_enabled + csv_delimiter
        +','+ csv_delimiter + is_chat_enabled + csv_delimiter
        +','+ csv_delimiter + is_whitelisted_extension + csv_delimiter
        +','+ csv_delimiter + whitelist_channels_str + csv_delimiter
      )
    }
  }
}
