import gspread
import psycopg2
import sys
from oauth2client.service_account import ServiceAccountCredentials
import retrieve_sheet_info
import upload_to_s3
import time
import multiprocessing
import s

if __name__ == '__main__':
    start = time.time()
    print('Refreshing cronjob')

    gc = s.getGC()
    connection = s.getConnection()

    #Master Spreadsheet with all of the links to scrape through
    master_workbook = gc.open_by_url('https://docs.google.com/spreadsheets/d/15Y8xdxbfWijBEqNR_yJ92vpALbFhDq34EbI902zGmU4/edit#gid=0')


    #Gets all of the values in the first column only which are the links
    link_sheet = master_workbook.worksheet('MAIN')
    query_sheet = master_workbook.worksheet('MASTER SQL')
    cron_sheet = master_workbook.worksheet('secret_mapping_cron')

    print('Uploading to s3')
    # Upload query results to s3
    upload_to_s3.upload(query_sheet,connection)

    print('Writing to Google sheet')
    # Writing to Cron Tab File
    retrieve_sheet_info.build_out_cron_job(link_sheet,cron_sheet,gc,connection)


    print('Updated cronjob, time took was: {}'.format(time.time()-start))

