import json
import gspread
from crontab import CronTab
from collections import defaultdict
import psycopg2
import os
import multiprocessing
import write_csv
import boto3
import time

def sheet_to_map(link_sheet):
    """ Takes the MAIN Worksheet and converts it into a Map with the links as the keys. """

    # Building out the map.
    query_list = defaultdict(list)
    values = link_sheet.get_all_values()
    for row_index in range(len(values)):
        # We don't need the first row as the first row are headers.
        if row_index == 0:
            continue
        else:
            query_list[values[row_index][3].strip()] = [i.strip() for i in values[row_index]]
    # Casting into a dictionary since it's harder to modify it.
    return dict(query_list)

def build_cron_map(cron_sheet):
    """ Takes the secret_mapping_cron sheet and builds out the Timestamp to Cron map out. """

    # Building out the map. Uses the Timestamp as the key.
    cron_map = defaultdict(str)
    values = cron_sheet.get_all_values()
    for index in range(len(values)):
        # We don't need the first row as the first row are headers.
        if index == 0:
            continue
        if len(values[index][4].strip()) == 0 or len(values[index][4].strip()) == 0:
            continue
        cron_map[values[index][0].strip()] = values[index][4].strip()
    # Casting into a dictionary since it's harder to modify it.
    return dict(cron_map)



def build_out_cron_job(link_sheet,cron_sheet,gc,connection):
    """ Builds out the cron commands and writes them into the crontab that query_to_gsheet has. """

    # Get the cron map and the link map.
    link_map = sheet_to_map(link_sheet)
    #cron_map = build_cron_map(cron_sheet)

    # Opening the crontab and removing all of the cron commands in there.
    #cron = CronTab(user='query_to_gsheet')
    #ron.remove_all(comment='Query')

    # Iterate through all of the links.
    processes = []
    counter = 0
    for link in link_map.keys():

        print(link)
        # Build out the json objects since it's easier to pass along the data into write_csv.py.
        data = defaultdict()
        data['user'] = link_map[link][0]
        data['link'] = link_map[link][2]
        data['write_sheet'] = link_map[link][3]
        data['queries'] = link_map[link][4].split(',')

        print('{},{}'.format(link,data))
        json_data = json.dumps(data)


        # Creates a new command with the json object that was created.
        #job = cron.new(command='/usr/bin/python3.6 /home/query_to_gsheet/query_to_googlesheet/write_csv.py \'{}\''.format(json_data),comment='Query')
        counter = write_csv.write(json_data,gc,boto3.client('s3'),counter)
        print('Waiting for next sheet')
        time.sleep(100)
        #job.setall(cron_map[link_map[link][1]])
        #job.enable()

    # Writes all of the cron jobs that was just created into query_to_gsheet's crontab.
    #cron.write_to_user(user=True)
    #for p in proceses:
        #p.join()
