-- Input: pass platform column in text
-- Output: cleaned up platform field in text

-- Notes: This is super manual - Serdar basically analyzed the top 20 tables
-- and mapped them to proper values and passed that through a simple generator.


create function public.f_get_platform (platform varchar(max))
  returns varchar(max)
stable
as $$
   select
   case lower($1)
     when 'web' then 'web'
     when 'wpb' then 'web'
     when 'wel' then 'web'

     when 'curse' then 'desktop'
     when 'desktop' then 'desktop'

     when 'playstation' then 'playstation'
     when 'ps4' then 'playstation'

     when 'xboxone' then 'xboxone'
     when 'xbox360' then 'xbox360'

     when 'mobile_web' then 'mobile_web'

     when 'ios' then 'ios'
     when 'ipad 3g' then 'ios'
     when 'ipad 4g' then 'ios'
     when 'ipad 2g' then 'ios'
     when 'ipad 5g air cell' then 'ios'
     when 'ipad 5g air' then 'ios'
     when 'iphone 5' then 'ios'
     when 'iphone 4' then 'ios'
     when 'iphone' then 'ios'
     when 'unknown ipad' then 'ios'
     when 'ipad 5g mini' then 'ios'
     when 'ipad 5g mini cell' then 'ios'
     when 'iphone 4s' then 'ios'
     when 'iphone 5s' then 'ios'
     when 'ipod touch 5g' then 'ios'

     when 'shieldtablet' then 'android'
     when 'android-19' then 'android'
     when 'android' then 'android'
     when 'android-23' then 'android'
     when 'android-17' then 'android'
     when 'android-22' then 'android'
     when 'android-25' then 'android'
     when 'android-16' then 'android'
     when 'android-21' then 'android'
     when 'android-15' then 'android'
     when 'android-18' then 'android'
     when 'android-24' then 'android'
     when 'aplroid' then 'android'
     when 'androfd' then 'android'
     when 'android-۲۲' then 'android'
     when 'anlboid' then 'android'
     when 'androfo' then 'android'
     when 'andrmid' then 'android'
     when 'andqtid' then 'android'

     when 'chromecast' then 'chromecast'

     else 'other'
     end
$$ language sql;
