DROP FUNCTION f_get_video_product_subtype(varchar, varchar, varchar, boolean) CASCADE;

-- Input: Broadcaster software as text, vod_type as text, content_mode as text, live as boolean.
-- Output: This dimension indicates what type of content user watched i.e. highlight, clip, archive. This field is currently not applicable to live content.
-- Possible values: 'upload', 'highlight', 'archive', 'clip', 'past_premiere',  'premiere_upload'
-- Note: this is intended to be used for reporting purposes when summing raw MW.
-- This does not enforce consistency with backend data from Jax.
create function public.f_get_video_product_subtype(
    broadcaster_software varchar(max),
    vod_type varchar(max),
    content_mode varchar(max),
    live boolean
)
returns varchar(max)
stable
as $$
  select
  case -- the order matters!
    -- vodcast: broadcaster_software like 'watch_party' or 'vodcast'
    when f_is_vodcast_bcsw($1)
      then f_get_vod_type($2)
    -- playlist: non-vodcast and content_mode=playlist, deprecated in 2017
    when nvl($3,'') = 'playlist'
      then f_get_vod_type($2)
    -- live: non-vodcast and non-playlist and live is true
    when $4 = true
      then 'not_applicable'
    -- vod: non-vodcast and non-playlist and live false
    when $4 = false
      then f_get_vod_type($2)
    -- vod: non-vodcast and non-playlist and live null and correct vod_type
    when f_is_correct_vod_type($2)
      then $2
    -- live: non-vodcast and non-playlist and live null and bad/missing vod type -- most likely live
    when not f_is_correct_vod_type($2)
      then 'not_applicable'
    -- fallback
    else 'unknown'
    end
$$ language sql;
