DROP FUNCTION f_numeral_format(FLOAT, VARCHAR, INTEGER) CASCADE;

-- input:
--  the_numeral = the number that you want to format
--  the_numeral_type = "number" or "percent"
--  the_numeral_precision = the decimal precsition that you want, possible values are 0|1|2|3|4|5|6
-- output: formatted numeral as number/percent/currency format

CREATE FUNCTION public.f_numeral_format (
    the_numeral FLOAT
    , the_numeral_type VARCHAR
    , the_numeral_precision INTEGER
)
RETURNS VARCHAR(MAX)
IMMUTABLE

AS $$

  SELECT
    CASE
      WHEN $2 = 'number' THEN
        CASE --START NESTED CASE
          WHEN $3=0 THEN
            CASE
              WHEN TRIM(to_char(ABS($1), '999,999,999,999,999,999,999,999,999'))='0' THEN '0'
              WHEN $1<0 THEN
                CASE WHEN ABS($1::FLOAT)>1 THEN '-'||TRIM(to_char($1*-1, '999,999,999,999,999,999,999,999,999'))
                ELSE '-0'||TRIM(to_char($1*-1, '999,999,999,999,999,999,999,999,999')) END
              WHEN $1<1 THEN TRIM(to_char($1, '999,999,999,999,999,999,999,999,999'))
              ELSE TRIM(to_char($1, '999,999,999,999,999,999,999,999,999'))
            END
          WHEN $3=1 THEN
            CASE
              WHEN TRIM(to_char(ABS($1), '999,999,999,999,999,999,999,999,999.9'))='.0' THEN '0.0'
              WHEN $1<0 THEN
                CASE WHEN ABS($1::FLOAT)>1 THEN '-'||TRIM(to_char($1*-1, '999,999,999,999,999,999,999,999,999.9'))
                ELSE '-0'||TRIM(to_char($1*-1, '999,999,999,999,999,999,999,999,999.9')) END
              WHEN $1<1 THEN '0'||TRIM(to_char($1, '999,999,999,999,999,999,999,999,999.9'))
              ELSE TRIM(to_char($1, '999,999,999,999,999,999,999,999,999.9'))
            END
          WHEN $3=2 THEN
            CASE
              WHEN TRIM(to_char(ABS($1), '999,999,999,999,999,999,999,999,999.99'))='.00' THEN '0.00'
              WHEN $1<0 THEN
                CASE WHEN ABS($1::FLOAT)>1 THEN '-'||TRIM(to_char($1*-1, '999,999,999,999,999,999,999,999,999.99'))
                ELSE '-0'||TRIM(to_char($1*-1, '999,999,999,999,999,999,999,999,999.99')) END
              WHEN $1<1 THEN '0'||TRIM(to_char($1, '999,999,999,999,999,999,999,999,999.99'))
              ELSE TRIM(to_char($1, '999,999,999,999,999,999,999,999,999.99'))
            END
          WHEN $3=3 THEN
            CASE
              WHEN TRIM(to_char(ABS($1), '999,999,999,999,999,999,999,999,999.999'))='.000' THEN '0.000'
              WHEN $1<0 THEN
                CASE WHEN ABS($1::FLOAT)>1 THEN '-'||TRIM(to_char($1*-1, '999,999,999,999,999,999,999,999,999.999'))
                ELSE '-0'||TRIM(to_char($1*-1, '999,999,999,999,999,999,999,999,999.999')) END
              WHEN $1<1 THEN '0'||TRIM(to_char($1, '999,999,999,999,999,999,999,999,999.999'))
              ELSE TRIM(to_char($1, '999,999,999,999,999,999,999,999,999.999'))
            END
          WHEN $3=4 THEN
            CASE
              WHEN TRIM(to_char(ABS($1), '999,999,999,999,999,999,999,999,999.9999'))='.0000' THEN '0.0000'
              WHEN $1<0 THEN
                CASE WHEN ABS($1::FLOAT)>1 THEN '-'||TRIM(to_char($1*-1, '999,999,999,999,999,999,999,999,999.9999'))
                ELSE '-0'||TRIM(to_char($1*-1, '999,999,999,999,999,999,999,999,999.9999')) END
              WHEN $1<1 THEN '0'||TRIM(to_char($1, '999,999,999,999,999,999,999,999,999.9999'))
              ELSE TRIM(to_char($1, '999,999,999,999,999,999,999,999,999.9999'))
            END
          WHEN $3=5 THEN
            CASE
              WHEN TRIM(to_char(ABS($1), '999,999,999,999,999,999,999,999,999.99999'))='.00000' THEN '0.00000'
              WHEN $1<0 THEN
                CASE WHEN ABS($1::FLOAT)>1 THEN '-'||TRIM(to_char($1*-1, '999,999,999,999,999,999,999,999,999.99999'))
                ELSE '-0'||TRIM(to_char($1*-1, '999,999,999,999,999,999,999,999,999.99999')) END
              WHEN $1<1 THEN '0'||TRIM(to_char($1, '999,999,999,999,999,999,999,999,999.99999'))
              ELSE TRIM(to_char($1, '999,999,999,999,999,999,999,999,999.99999'))
            END
          WHEN $3=6 THEN
            CASE
              WHEN TRIM(to_char(ABS($1), '999,999,999,999,999,999,999,999,999.999999'))='.000000' THEN '0.000000'
              WHEN $1<0 THEN
                CASE WHEN ABS($1::FLOAT)>1 THEN '-'||TRIM(to_char($1*-1, '999,999,999,999,999,999,999,999,999.999999'))
                ELSE '-0'||TRIM(to_char($1*-1, '999,999,999,999,999,999,999,999,999.999999')) END
              WHEN $1<1 THEN '0'||TRIM(to_char($1, '999,999,999,999,999,999,999,999,999.999999'))
              ELSE TRIM(to_char($1, '999,999,999,999,999,999,999,999,999.999999'))
            END
          ELSE 'ERROR_NUMBER'
        END --END NESTED CASE
      WHEN $2 = 'percent' THEN
        CASE --START NESTED CASE
          WHEN $3=0 THEN
            CASE
              WHEN TRIM(to_char(ABS($1)*100, '999,999,999,999,999,999,999,999,999'))='0' THEN '0%'
              WHEN $1::FLOAT*100<0 THEN
                CASE WHEN ABS($1::FLOAT)*100>1 THEN '-'||TRIM(to_char($1*100*-1, '999,999,999,999,999,999,999,999,999'))||'%'
                ELSE '-0'||TRIM(to_char($1*100*-1, '999,999,999,999,999,999,999,999,999'))||'%' END
              WHEN $1::FLOAT*100<1 THEN '0'||TRIM(to_char($1*100, '999,999,999,999,999,999,999,999,999'))||'%'
              ELSE TRIM(to_char($1::FLOAT*100, '999,999,999,999,999,999,999,999,999'))||'%'
            END
          WHEN $3=1 THEN
            CASE
              WHEN TRIM(to_char(ABS($1)*100, '999,999,999,999,999,999,999,999,999.9'))='.0' THEN '0.0%'
              WHEN $1::FLOAT*100<0 THEN
                CASE WHEN ABS($1::FLOAT)*100>1 THEN '-'||TRIM(to_char($1*100*-1, '999,999,999,999,999,999,999,999,999.9'))||'%'
                ELSE '-0'||TRIM(to_char($1*100*-1, '999,999,999,999,999,999,999,999,999.9'))||'%' END
              WHEN $1::FLOAT*100<1 THEN '0'||TRIM(to_char($1*100, '999,999,999,999,999,999,999,999,999.9'))||'%'
              ELSE TRIM(to_char($1::FLOAT*100, '999,999,999,999,999,999,999,999,999.9'))||'%'
            END
          WHEN $3=2 THEN
            CASE
              WHEN TRIM(to_char(ABS($1)*100, '999,999,999,999,999,999,999,999,999.99'))='.00' THEN '0.00%'
              WHEN $1::FLOAT*100<0 THEN
                CASE WHEN ABS($1::FLOAT)*100>1 THEN '-'||TRIM(to_char($1*100*-1, '999,999,999,999,999,999,999,999,999.99'))||'%'
                ELSE '-0'||TRIM(to_char($1*100*-1, '999,999,999,999,999,999,999,999,999.99'))||'%' END
              WHEN $1::FLOAT*100<1 THEN '0'||TRIM(to_char($1*100, '999,999,999,999,999,999,999,999,999.99'))||'%'
              ELSE TRIM(to_char($1::FLOAT*100, '999,999,999,999,999,999,999,999,999.99'))||'%'
            END
          WHEN $3=3 THEN
            CASE
              WHEN TRIM(to_char(ABS($1)*100, '999,999,999,999,999,999,999,999,999.999'))='.000' THEN '0.000%'
              WHEN $1::FLOAT*100<0 THEN
                CASE WHEN ABS($1::FLOAT)*100>1 THEN '-'||TRIM(to_char($1*100*-1, '999,999,999,999,999,999,999,999,999.999'))||'%'
                ELSE '-0'||TRIM(to_char($1*100*-1, '999,999,999,999,999,999,999,999,999.999'))||'%' END
              WHEN $1::FLOAT*100<1 THEN '0'||TRIM(to_char($1*100, '999,999,999,999,999,999,999,999,999.999'))||'%'
              ELSE TRIM(to_char($1::FLOAT*100, '999,999,999,999,999,999,999,999,999.999'))||'%'
            END
          WHEN $3=4 THEN
            CASE
              WHEN TRIM(to_char(ABS($1)*100, '999,999,999,999,999,999,999,999,999.9999'))='.0000' THEN '0.0000%'
              WHEN $1::FLOAT*100<0 THEN
                CASE WHEN ABS($1::FLOAT)*100>1 THEN '-'||TRIM(to_char($1*100*-1, '999,999,999,999,999,999,999,999,999.9999'))||'%'
                ELSE '-0'||TRIM(to_char($1*100*-1, '999,999,999,999,999,999,999,999,999.9999'))||'%' END
              WHEN $1::FLOAT*100<1 THEN '0'||TRIM(to_char($1*100, '999,999,999,999,999,999,999,999,999.9999'))||'%'
              ELSE TRIM(to_char($1::FLOAT*100, '999,999,999,999,999,999,999,999,999.9999'))||'%'
            END
          WHEN $3=5 THEN
            CASE
              WHEN TRIM(to_char(ABS($1)*100, '999,999,999,999,999,999,999,999,999.99999'))='.00000' THEN '0.00000%'
              WHEN $1::FLOAT*100<0 THEN
                CASE WHEN ABS($1::FLOAT)*100>1 THEN '-'||TRIM(to_char($1*100*-1, '999,999,999,999,999,999,999,999,999.99999'))||'%'
                ELSE '-0'||TRIM(to_char($1*100*-1, '999,999,999,999,999,999,999,999,999.99999'))||'%' END
              WHEN $1::FLOAT*100<1 THEN '0'||TRIM(to_char($1*100, '999,999,999,999,999,999,999,999,999.99999'))||'%'
              ELSE TRIM(to_char($1::FLOAT*100, '999,999,999,999,999,999,999,999,999.99999'))||'%'
            END
          WHEN $3=6 THEN
            CASE
              WHEN TRIM(to_char(ABS($1)*100, '999,999,999,999,999,999,999,999,999.999999'))='.000000' THEN '0.000000%'
              WHEN $1::FLOAT*100<0 THEN
                CASE WHEN ABS($1::FLOAT)*100>1 THEN '-'||TRIM(to_char($1*100*-1, '999,999,999,999,999,999,999,999,999.999999'))||'%'
                ELSE '-0'||TRIM(to_char($1*100*-1, '999,999,999,999,999,999,999,999,999.999999'))||'%' END
              WHEN $1::FLOAT*100<1 THEN '0'||TRIM(to_char($1*100, '999,999,999,999,999,999,999,999,999.999999'))||'%'
              ELSE TRIM(to_char($1::FLOAT*100, '999,999,999,999,999,999,999,999,999.999999'))||'%'
            END
          ELSE 'ERROR_PERCENT'
        END --END NESTED CASE
      -- WHEN $2 = 'currency' THEN
      --   CASE --START NESTED CASE
      --     WHEN $3=0 THEN
      --       CASE
      --         WHEN TRIM(to_char(ABS($1), '999,999,999,999,999,999,999,999,999'))='0' THEN '$0'
      --         WHEN $1<0 THEN
      --           CASE WHEN ABS($1::FLOAT)>1 THEN '-$'||TRIM(to_char($1*-1, '999,999,999,999,999,999,999,999,999'))
      --           ELSE '-$0'||TRIM(to_char($1*-1, '999,999,999,999,999,999,999,999,999')) END
      --         WHEN $1<1 THEN '-$'||TRIM(to_char($1, '999,999,999,999,999,999,999,999,999'))
      --         ELSE '-$'||TRIM(to_char($1, '999,999,999,999,999,999,999,999,999'))
      --       END
      --     WHEN $3=1 THEN
      --       CASE
      --         WHEN TRIM(to_char(ABS($1), '999,999,999,999,999,999,999,999,999.9'))='.0' THEN '$0.0'
      --         WHEN $1<0 THEN
      --           CASE WHEN ABS($1::FLOAT)>1 THEN '-$'||TRIM(to_char($1*-1, '999,999,999,999,999,999,999,999,999.9'))
      --           ELSE '-$0'||TRIM(to_char($1*-1, '999,999,999,999,999,999,999,999,999.9')) END
      --         WHEN $1<1 THEN '$0'||TRIM(to_char($1, '999,999,999,999,999,999,999,999,999.9'))
      --         ELSE '-$'||TRIM(to_char($1, '999,999,999,999,999,999,999,999,999.9'))
      --       END
      --     WHEN $3=2 THEN
      --       CASE
      --         WHEN TRIM(to_char(ABS($1), '999,999,999,999,999,999,999,999,999.99'))='.00' THEN '$0.00'
      --         WHEN $1<0 THEN
      --           CASE WHEN ABS($1::FLOAT)>1 THEN '-$'||TRIM(to_char($1*-1, '999,999,999,999,999,999,999,999,999.99'))
      --           ELSE '-$0'||TRIM(to_char($1*-1, '999,999,999,999,999,999,999,999,999.99')) END
      --         WHEN $1<1 THEN '$0'||TRIM(to_char($1, '999,999,999,999,999,999,999,999,999.99'))
      --         ELSE '-$'||TRIM(to_char($1, '999,999,999,999,999,999,999,999,999.99'))
      --       END
      --     WHEN $3=3 THEN
      --       CASE
      --         WHEN TRIM(to_char(ABS($1), '999,999,999,999,999,999,999,999,999.999'))='.000' THEN '$0.000'
      --         WHEN $1<0 THEN
      --           CASE WHEN ABS($1::FLOAT)>1 THEN '-$'||TRIM(to_char($1*-1, '999,999,999,999,999,999,999,999,999.999'))
      --           ELSE '-$0'||TRIM(to_char($1*-1, '999,999,999,999,999,999,999,999,999.999')) END
      --         WHEN $1<1 THEN '$0'||TRIM(to_char($1, '999,999,999,999,999,999,999,999,999.999'))
      --         ELSE '-$'||TRIM(to_char($1, '999,999,999,999,999,999,999,999,999.999'))
      --       END
      --     WHEN $3=4 THEN
      --       CASE
      --         WHEN TRIM(to_char(ABS($1), '999,999,999,999,999,999,999,999,999.9999'))='.0000' THEN '$0.0000'
      --         WHEN $1<0 THEN
      --           CASE WHEN ABS($1::FLOAT)>1 THEN '-$'||TRIM(to_char($1*-1, '999,999,999,999,999,999,999,999,999.9999'))
      --           ELSE '-$0'||TRIM(to_char($1*-1, '999,999,999,999,999,999,999,999,999.9999')) END
      --         WHEN $1<1 THEN '$0'||TRIM(to_char($1, '999,999,999,999,999,999,999,999,999.9999'))
      --         ELSE '-$'||TRIM(to_char($1, '999,999,999,999,999,999,999,999,999.9999'))
      --       END
      --     WHEN $3=5 THEN
      --       CASE
      --         WHEN TRIM(to_char(ABS($1), '999,999,999,999,999,999,999,999,999.99999'))='.00000' THEN '$0.00000'
      --         WHEN $1<0 THEN
      --           CASE WHEN ABS($1::FLOAT)>1 THEN '-$'||TRIM(to_char($1*-1, '999,999,999,999,999,999,999,999,999.99999'))
      --           ELSE '-$0'||TRIM(to_char($1*-1, '999,999,999,999,999,999,999,999,999.99999')) END
      --         WHEN $1<1 THEN '$0'||TRIM(to_char($1, '999,999,999,999,999,999,999,999,999.99999'))
      --         ELSE '-$'||TRIM(to_char($1, '999,999,999,999,999,999,999,999,999.99999'))
      --       END
      --     WHEN $3=6 THEN
      --       CASE
      --         WHEN TRIM(to_char(ABS($1), '999,999,999,999,999,999,999,999,999.999999'))='.000000' THEN '$0.000000'
      --         WHEN $1<0 THEN
      --           CASE WHEN ABS($1::FLOAT)>1 THEN '-$'||TRIM(to_char($1*-1, '999,999,999,999,999,999,999,999,999.999999'))
      --           ELSE '-$0'||TRIM(to_char($1*-1, '999,999,999,999,999,999,999,999,999.999999')) END
      --         WHEN $1<1 THEN '$0'||TRIM(to_char($1, '999,999,999,999,999,999,999,999,999.999999'))
      --         ELSE '-$'||TRIM(to_char($1, '999,999,999,999,999,999,999,999,999.999999'))
      --       END
      --     ELSE 'ERROR_NUMBER'
      --   END --END NESTED CASE
      ELSE 'ERROR_TYPE'
    END


$$ language sql;





--TEST CASE DATA QA

WITH
the_data AS (SELECT 0.00011111 AS the_number)
SELECT f_numeral_format(the_number,'number',0) AS the_num, f_numeral_format(the_number, 'percent',0) AS the_pct0
FROM the_data;

WITH
the_data AS (SELECT 0.00011111 AS the_number)
SELECT f_numeral_format(the_number,'number',1) AS the_num, f_numeral_format(the_number, 'percent',1) AS the_pct1
FROM the_data;

WITH
the_data AS (SELECT 0.00011111 AS the_number)
SELECT f_numeral_format(the_number,'number',2) AS the_num, f_numeral_format(the_number, 'percent',2) AS the_pct2
FROM the_data;

WITH
the_data AS (SELECT 0.00011111 AS the_number)
SELECT f_numeral_format(the_number,'number',3) AS the_num, f_numeral_format(the_number, 'percent',3) AS the_pct3
FROM the_data;
WITH
the_data AS (SELECT 0.00011111 AS the_number)
SELECT f_numeral_format(the_number,'number',4) AS the_num, f_numeral_format(the_number, 'percent',4) AS the_pct4
FROM the_data;
WITH
the_data AS (SELECT 0.00011111 AS the_number)
SELECT f_numeral_format(the_number,'number',5) AS the_num, f_numeral_format(the_number, 'percent',5) AS the_pct5
FROM the_data;
WITH
the_data AS (SELECT 0.00011111 AS the_number)
SELECT f_numeral_format(the_number,'number',6) AS the_num, f_numeral_format(the_number, 'percent',6) AS the_pct6
FROM the_data;



WITH
the_data AS (SELECT -0.00011111 AS the_number)
SELECT f_numeral_format(the_number,'number',0) AS the_num, f_numeral_format(the_number, 'percent',0) AS the_pct0
FROM the_data;

WITH
the_data AS (SELECT -0.00011111 AS the_number)
SELECT f_numeral_format(the_number,'number',1) AS the_num, f_numeral_format(the_number, 'percent',1) AS the_pct1
FROM the_data;

WITH
the_data AS (SELECT -0.00011111 AS the_number)
SELECT f_numeral_format(the_number,'number',2) AS the_num, f_numeral_format(the_number, 'percent',2) AS the_pct2
FROM the_data;

WITH
the_data AS (SELECT -0.00011111 AS the_number)
SELECT f_numeral_format(the_number,'number',3) AS the_num, f_numeral_format(the_number, 'percent',3) AS the_pct3
FROM the_data;
WITH
the_data AS (SELECT -0.00011111 AS the_number)
SELECT f_numeral_format(the_number,'number',4) AS the_num, f_numeral_format(the_number, 'percent',4) AS the_pct4
FROM the_data;
WITH
the_data AS (SELECT -0.00011111 AS the_number)
SELECT f_numeral_format(the_number,'number',5) AS the_num, f_numeral_format(the_number, 'percent',5) AS the_pct5
FROM the_data;
WITH
the_data AS (SELECT -0.00011111 AS the_number)
SELECT f_numeral_format(the_number,'number',6) AS the_num, f_numeral_format(the_number, 'percent',6) AS the_pct6
FROM the_data;


WITH
the_data AS (SELECT -0.1536 AS the_number)
SELECT f_numeral_format(the_number,'number',0) AS the_num, f_numeral_format(the_number, 'percent',0) AS the_pct0
FROM the_data;

WITH
the_data AS (SELECT -0.1536 AS the_number)
SELECT f_numeral_format(the_number,'number',1) AS the_num, f_numeral_format(the_number, 'percent',1) AS the_pct1
FROM the_data;


WITH
the_data AS (SELECT -0.1536 AS the_number)
SELECT f_numeral_format(the_number,'number',2) AS the_num, f_numeral_format(the_number, 'percent',2) AS the_pct2
FROM the_data;


WITH
the_data AS (SELECT -0.1536 AS the_number)
SELECT f_numeral_format(the_number,'number',3) AS the_num, f_numeral_format(the_number, 'percent',3) AS the_pct3
FROM the_data;


WITH
the_data AS (SELECT -0.1536 AS the_number)
SELECT f_numeral_format(the_number,'number',4) AS the_num, f_numeral_format(the_number, 'percent',4) AS the_pct4
FROM the_data;

WITH
the_data AS (SELECT -0.1536 AS the_number)
SELECT f_numeral_format(the_number,'number',5) AS the_num, f_numeral_format(the_number, 'percent',5) AS the_pct5
FROM the_data;

WITH
the_data AS (SELECT -0.1536 AS the_number)
SELECT f_numeral_format(the_number,'number',6) AS the_num, f_numeral_format(the_number, 'percent',6) AS the_pct6
FROM the_data;



WITH
the_data AS (SELECT 0.1536 AS the_number)
SELECT f_numeral_format(the_number,'number',0) AS the_num, f_numeral_format(the_number, 'percent',0) AS the_pct0
FROM the_data;

WITH
the_data AS (SELECT 0.1536 AS the_number)
SELECT f_numeral_format(the_number,'number',1) AS the_num, f_numeral_format(the_number, 'percent',1) AS the_pct1
FROM the_data;


WITH
the_data AS (SELECT 0.1536 AS the_number)
SELECT f_numeral_format(the_number,'number',2) AS the_num, f_numeral_format(the_number, 'percent',2) AS the_pct2
FROM the_data;


WITH
the_data AS (SELECT 0.1536 AS the_number)
SELECT f_numeral_format(the_number,'number',3) AS the_num, f_numeral_format(the_number, 'percent',3) AS the_pct3
FROM the_data;


WITH
the_data AS (SELECT 0.1536 AS the_number)
SELECT f_numeral_format(the_number,'number',4) AS the_num, f_numeral_format(the_number, 'percent',4) AS the_pct4
FROM the_data;

WITH
the_data AS (SELECT 0.1536 AS the_number)
SELECT f_numeral_format(the_number,'number',5) AS the_num, f_numeral_format(the_number, 'percent',5) AS the_pct5
FROM the_data;

WITH
the_data AS (SELECT 0.1536 AS the_number)
SELECT f_numeral_format(the_number,'number',6) AS the_num, f_numeral_format(the_number, 'percent',6) AS the_pct6
FROM the_data;


WITH
the_data AS (SELECT -99.00011111 AS the_number)
SELECT f_numeral_format(the_number,'number',0) AS the_num, f_numeral_format(the_number, 'percent',0) AS the_pct0
FROM the_data;

WITH
the_data AS (SELECT -99.00011111 AS the_number)
SELECT f_numeral_format(the_number,'number',1) AS the_num, f_numeral_format(the_number, 'percent',1) AS the_pct1
FROM the_data;

WITH
the_data AS (SELECT -99.00011111 AS the_number)
SELECT f_numeral_format(the_number,'number',2) AS the_num, f_numeral_format(the_number, 'percent',2) AS the_pct2
FROM the_data;

WITH
the_data AS (SELECT -99.00011111 AS the_number)
SELECT f_numeral_format(the_number,'number',3) AS the_num, f_numeral_format(the_number, 'percent',3) AS the_pct3
FROM the_data;
WITH
the_data AS (SELECT -99.00011111 AS the_number)
SELECT f_numeral_format(the_number,'number',4) AS the_num, f_numeral_format(the_number, 'percent',4) AS the_pct4
FROM the_data;
WITH
the_data AS (SELECT -99.00011111 AS the_number)
SELECT f_numeral_format(the_number,'number',5) AS the_num, f_numeral_format(the_number, 'percent',5) AS the_pct5
FROM the_data;
WITH
the_data AS (SELECT -99.00011111 AS the_number)
SELECT f_numeral_format(the_number,'number',6) AS the_num, f_numeral_format(the_number, 'percent',6) AS the_pct6
FROM the_data;


WITH
the_data AS (SELECT 99.00011111 AS the_number)
SELECT f_numeral_format(the_number,'number',0) AS the_num, f_numeral_format(the_number, 'percent',0) AS the_pct0
FROM the_data;

WITH
the_data AS (SELECT 99.00011111 AS the_number)
SELECT f_numeral_format(the_number,'number',1) AS the_num, f_numeral_format(the_number, 'percent',1) AS the_pct1
FROM the_data;

WITH
the_data AS (SELECT 99.00011111 AS the_number)
SELECT f_numeral_format(the_number,'number',2) AS the_num, f_numeral_format(the_number, 'percent',2) AS the_pct2
FROM the_data;

WITH
the_data AS (SELECT 99.00011111 AS the_number)
SELECT f_numeral_format(the_number,'number',3) AS the_num, f_numeral_format(the_number, 'percent',3) AS the_pct3
FROM the_data;
WITH
the_data AS (SELECT 99.00011111 AS the_number)
SELECT f_numeral_format(the_number,'number',4) AS the_num, f_numeral_format(the_number, 'percent',4) AS the_pct4
FROM the_data;
WITH
the_data AS (SELECT 99.00011111 AS the_number)
SELECT f_numeral_format(the_number,'number',5) AS the_num, f_numeral_format(the_number, 'percent',5) AS the_pct5
FROM the_data;
WITH
the_data AS (SELECT 99.00011111 AS the_number)
SELECT f_numeral_format(the_number,'number',6) AS the_num, f_numeral_format(the_number, 'percent',6) AS the_pct6
FROM the_data;

--
--
--
-- SELECT CASE WHEN the_number<1 THEN  '0'||trim(to_char(the_number, '999,999.9999'))
-- ELSE to_char(the_number, '999,999.9999') END AS the_formatted_number
-- FROM the_data
