
DROP FUNCTION f_random_between(INT, INT) CASCADE;

-- Input: low as integer, high as integer
-- Output: a random integer between "low_num" and "high_num" (inclusive of low and high)
-- Note: this is a more generalized version of the random() function which returns a float between 0 and 1

CREATE OR REPLACE FUNCTION public.f_random_between(
  low_num BIGINT,
  high_num BIGINT
)
RETURNS BIGINT
VOLATILE
AS $$

  SELECT floor(random()* ($2-$1 + 1) + $1)::BIGINT


$$ language sql;
