------------------------- TABLE OF CONTENTS -------------------------
-- Create a new schema
-- Grant select access for a specific schema to a specfic group of users
---------------------------------------------------------------------


-- Create a new schema
CREATE SCHEMA IF NOT EXISTS dx_metadata;
CREATE SCHEMA IF NOT EXISTS dx_rollup;
CREATE SCHEMA IF NOT EXISTS dx_table_def;
CREATE SCHEMA IF NOT EXISTS dx_sandbox;
CREATE SCHEMA IF NOT EXISTS dx_sql_test;
CREATE SCHEMA IF NOT EXISTS dx_csv;
CREATE SCHEMA IF NOT EXISTS dx_airflow_test;
CREATE SCHEMA IF NOT EXISTS dx_admin;









-- Grant select access for a specific schema to a specfic group of users
-- NOTE: Edit the parameters in the CTE, then run the query, then run the results of the query as Twitcher user
-- NOTE: Currently there are only 3 "Groups": aggregate_only, analyst, readonly
-- NOTE: There are 7 custom schemas we maintain in our Tahoe Tap: dx_metadata, dx_rollup, dx_sandbox, dx_table_def, dx_csv, dx_airflow_test, dx_sql_test
-- GROUP readonly has SELECT powers on the schemas: dx_metadata, dx_rollup, dx_sandbox, cubes, tahoe etc
-- GROUP aggregate_only has SELECT powers on the schemas: dx_metadata, dx_rollup
-- GROUP analyst has SELECT & INSERT & DELETE powers on the schemas: dx_metadata, dx_rollup, dx_sandbox, cubes, tahoe etc

WITH
the_schema AS (SELECT 'dx_sandbox' AS schema_name)
, the_group AS (SELECT 'analyst' AS group_name)

SELECT 'GRANT USAGE ON SCHEMA ' || (SELECT schema_name FROM the_schema) || ' TO GROUP ' || (SELECT group_name FROM the_group) || '; -- Grant Usage permission to Group for specific Schema'
UNION ALL
SELECT 'GRANT SELECT ON ALL TABLES IN SCHEMA ' || (SELECT schema_name FROM the_schema) || ' TO GROUP ' || (SELECT group_name FROM the_group) || '; -- Grant Select permission to Group for specific Schema'
UNION ALL
SELECT 'ALTER DEFAULT PRIVILEGES FOR USER tahoe IN SCHEMA ' || (SELECT schema_name FROM the_schema) || ' GRANT SELECT ON TABLES TO GROUP ' || (SELECT group_name FROM the_group) || '; -- Alter Default Privileges to maintain the permissions on new tables'
UNION ALL
SELECT 'ALTER DEFAULT PRIVILEGES FOR USER twitcher IN SCHEMA ' || (SELECT schema_name FROM the_schema) || ' GRANT SELECT ON TABLES TO GROUP ' || (SELECT group_name FROM the_group) || '; -- Alter Default Privileges to maintain the permissions on new tables'
UNION ALL
SELECT 'ALTER DEFAULT PRIVILEGES FOR USER yanghung IN SCHEMA ' || (SELECT schema_name FROM the_schema) || ' GRANT SELECT ON TABLES TO GROUP ' || (SELECT group_name FROM the_group) || '; -- Alter Default Privileges to maintain the permissions on new tables'
UNION ALL
SELECT 'ALTER DEFAULT PRIVILEGES FOR USER pothurs IN SCHEMA ' || (SELECT schema_name FROM the_schema) || ' GRANT SELECT ON TABLES TO GROUP ' || (SELECT group_name FROM the_group) || '; -- Alter Default Privileges to maintain the permissions on new tables'
UNION ALL
SELECT 'ALTER DEFAULT PRIVILEGES FOR USER wanrp IN SCHEMA ' || (SELECT schema_name FROM the_schema) || ' GRANT SELECT ON TABLES TO GROUP ' || (SELECT group_name FROM the_group) || '; -- Alter Default Privileges to maintain the permissions on new tables'
UNION ALL
SELECT 'ALTER DEFAULT PRIVILEGES FOR USER hoanghh IN SCHEMA ' || (SELECT schema_name FROM the_schema) || ' GRANT SELECT ON TABLES TO GROUP ' || (SELECT group_name FROM the_group) || '; -- Alter Default Privileges to maintain the permissions on new tables'
UNION ALL
SELECT 'ALTER DEFAULT PRIVILEGES FOR USER manchikc IN SCHEMA ' || (SELECT schema_name FROM the_schema) || ' GRANT SELECT ON TABLES TO GROUP ' || (SELECT group_name FROM the_group) || '; -- Alter Default Privileges to maintain the permissions on new tables'
UNION ALL
SELECT 'ALTER DEFAULT PRIVILEGES FOR USER mode_analyst_user IN SCHEMA ' || (SELECT schema_name FROM the_schema) || ' GRANT SELECT ON TABLES TO GROUP ' || (SELECT group_name FROM the_group) || '; -- Alter Default Privileges to maintain the permissions on new tables'



UNION ALL SELECT '----------------------------------------------------------------------------------'
UNION ALL SELECT '---------------  STOP HERE FOR aggregate_only AND readonly GROUPS  ---------------'
UNION ALL SELECT '----------------------------------------------------------------------------------'

UNION ALL
SELECT 'GRANT CREATE ON SCHEMA ' || (SELECT schema_name FROM the_schema) || ' TO GROUP ' || (SELECT group_name FROM the_group) || '; -- Grant CREATE privileges to Group for specific Schema'
UNION ALL
SELECT 'GRANT DELETE ON ALL TABLES IN SCHEMA ' || (SELECT schema_name FROM the_schema) || ' TO GROUP ' || (SELECT group_name FROM the_group) || '; -- Grant DELETE permission to Group for specific Schema'
UNION ALL
SELECT 'GRANT INSERT ON ALL TABLES IN SCHEMA ' || (SELECT schema_name FROM the_schema) || ' TO GROUP ' || (SELECT group_name FROM the_group) || '; -- Grant INSERT permission to Group for specific Schema'

UNION ALL
SELECT 'ALTER DEFAULT PRIVILEGES FOR USER twitcher IN SCHEMA ' || (SELECT schema_name FROM the_schema) || ' GRANT DELETE ON TABLES TO GROUP ' || (SELECT group_name FROM the_group) || '; -- Alter Default Privileges to maintain the permissions on new tables'
UNION ALL
SELECT 'ALTER DEFAULT PRIVILEGES FOR USER yanghung IN SCHEMA ' || (SELECT schema_name FROM the_schema) || ' GRANT DELETE ON TABLES TO GROUP ' || (SELECT group_name FROM the_group) || '; -- Alter Default Privileges to maintain the permissions on new tables'
UNION ALL
SELECT 'ALTER DEFAULT PRIVILEGES FOR USER pothurs IN SCHEMA ' || (SELECT schema_name FROM the_schema) || ' GRANT DELETE ON TABLES TO GROUP ' || (SELECT group_name FROM the_group) || '; -- Alter Default Privileges to maintain the permissions on new tables'
UNION ALL
SELECT 'ALTER DEFAULT PRIVILEGES FOR USER wanrp IN SCHEMA ' || (SELECT schema_name FROM the_schema) || ' GRANT DELETE ON TABLES TO GROUP ' || (SELECT group_name FROM the_group) || '; -- Alter Default Privileges to maintain the permissions on new tables'
UNION ALL
SELECT 'ALTER DEFAULT PRIVILEGES FOR USER hoanghh IN SCHEMA ' || (SELECT schema_name FROM the_schema) || ' GRANT DELETE ON TABLES TO GROUP ' || (SELECT group_name FROM the_group) || '; -- Alter Default Privileges to maintain the permissions on new tables'
UNION ALL
SELECT 'ALTER DEFAULT PRIVILEGES FOR USER manchikc IN SCHEMA ' || (SELECT schema_name FROM the_schema) || ' GRANT DELETE ON TABLES TO GROUP ' || (SELECT group_name FROM the_group) || '; -- Alter Default Privileges to maintain the permissions on new tables'
UNION ALL
SELECT 'ALTER DEFAULT PRIVILEGES FOR USER mode_superuser IN SCHEMA ' || (SELECT schema_name FROM the_schema) || ' GRANT DELETE ON TABLES TO GROUP ' || (SELECT group_name FROM the_group) || '; -- Alter Default Privileges to maintain the permissions on new tables'


UNION ALL
SELECT 'ALTER DEFAULT PRIVILEGES FOR USER twitcher IN SCHEMA ' || (SELECT schema_name FROM the_schema) || ' GRANT INSERT ON TABLES TO GROUP ' || (SELECT group_name FROM the_group) || '; -- Alter Default Privileges to maintain the permissions on new tables'
UNION ALL
SELECT 'ALTER DEFAULT PRIVILEGES FOR USER yanghung IN SCHEMA ' || (SELECT schema_name FROM the_schema) || ' GRANT INSERT ON TABLES TO GROUP ' || (SELECT group_name FROM the_group) || '; -- Alter Default Privileges to maintain the permissions on new tables'
UNION ALL
SELECT 'ALTER DEFAULT PRIVILEGES FOR USER pothurs IN SCHEMA ' || (SELECT schema_name FROM the_schema) || ' GRANT INSERT ON TABLES TO GROUP ' || (SELECT group_name FROM the_group) || '; -- Alter Default Privileges to maintain the permissions on new tables'
UNION ALL
SELECT 'ALTER DEFAULT PRIVILEGES FOR USER wanrp IN SCHEMA ' || (SELECT schema_name FROM the_schema) || ' GRANT INSERT ON TABLES TO GROUP ' || (SELECT group_name FROM the_group) || '; -- Alter Default Privileges to maintain the permissions on new tables'
UNION ALL
SELECT 'ALTER DEFAULT PRIVILEGES FOR USER hoanghh IN SCHEMA ' || (SELECT schema_name FROM the_schema) || ' GRANT INSERT ON TABLES TO GROUP ' || (SELECT group_name FROM the_group) || '; -- Alter Default Privileges to maintain the permissions on new tables'
UNION ALL
SELECT 'ALTER DEFAULT PRIVILEGES FOR USER manchikc IN SCHEMA ' || (SELECT schema_name FROM the_schema) || ' GRANT INSERT ON TABLES TO GROUP ' || (SELECT group_name FROM the_group) || '; -- Alter Default Privileges to maintain the permissions on new tables'
UNION ALL
SELECT 'ALTER DEFAULT PRIVILEGES FOR USER mode_analyst_user IN SCHEMA ' || (SELECT schema_name FROM the_schema) || ' GRANT INSERT ON TABLES TO GROUP ' || (SELECT group_name FROM the_group) || '; -- Alter Default Privileges to maintain the permissions on new tables'

UNION ALL SELECT '-------------------------------------------------------------------------------------'
UNION ALL SELECT '-------------------------------------------------------------------------------------'
UNION ALL SELECT '-------------------------------------------------------------------------------------'
UNION ALL SELECT '---------------  USE THE COMMANDS BELOW TO REVOKE POWERS TO A SCHEMA  ---------------'
UNION ALL SELECT '-------------------------------------------------------------------------------------'
UNION ALL SELECT '-------------------------------------------------------------------------------------'
UNION ALL SELECT '-------------------------------------------------------------------------------------'

UNION ALL
SELECT 'REVOKE CREATE ON SCHEMA ' || (SELECT schema_name FROM the_schema) || ' FROM GROUP ' || (SELECT group_name FROM the_group) || '; -- Revoke CREATE privileges from group'
UNION ALL
SELECT 'REVOKE SELECT ON ALL TABLES IN SCHEMA ' || (SELECT schema_name FROM the_schema) || ' FROM GROUP ' || (SELECT group_name FROM the_group) || '; -- Revoke SELECT permission from Group for specific Schema'
UNION ALL
SELECT 'REVOKE DELETE ON ALL TABLES IN SCHEMA ' || (SELECT schema_name FROM the_schema) || ' FROM GROUP ' || (SELECT group_name FROM the_group) || '; -- Revoke DELETE permission from Group for specific Schema'
UNION ALL
SELECT 'REVOKE INSERT ON ALL TABLES IN SCHEMA ' || (SELECT schema_name FROM the_schema) || ' FROM GROUP ' || (SELECT group_name FROM the_group) || '; -- Revoke INSERT permission from Group for specific Schema'
;
