------------------------- TABLE OF CONTENTS -------------------------
-- See all users and their groups that they are in
-- See all of the schemas
-- See all the tables and columns in a schema
-- See load csv errors
-- See current "tableau" queries (must use twitcher)
---------------------------------------------------------------------



-- See all users and their groups that they are in
-- NOTE: Currently there are only 3 "Groups": aggregate_only, analyst, readonly
-- product=# SELECT DISTINCT groname AS group_name FROM pg_group;
--    group_name
-- ----------------
--  aggregate_only
--  analyst
--  readonly
-- (3 rows)

SELECT usename AS user_name, groname AS group_name, usesysid AS userid
FROM pg_user, pg_group
WHERE pg_user.usesysid = ANY(pg_group.grolist)
AND pg_group.groname in (SELECT DISTINCT pg_group.groname from pg_group)
;



-- See all of the schemas
WITH
users_log AS (
  SELECT usesysid AS user_id, usename::VARCHAR(50) AS user_name, usecreatedb AS flag_create_db, usesuper AS flag_super
  FROM pg_user
)
SELECT nspname AS schema_name, nspowner AS owner_id, user_name, nspacl AS some_description
FROM pg_namespace AS base
LEFT JOIN users_log AS ul ON ul.user_id = base.nspowner
ORDER BY 2,1;


-- See all the tables and columns in a schema
SELECT "table_schema", "table_name", "column_name", "ordinal_position" AS "position"
  , CASE
      WHEN data_type IN ('character varying','character') THEN 'varchar'||'('||character_maximum_length||')'
      WHEN data_type LIKE '%timestamp%' THEN 'timestamp'
      ELSE data_type
    END AS data_type
FROM dx_table_def.svv_columns_data_dump AS base
WHERE table_schema IN (
  'metadata'
  , 'cubes'
  , 'dbsnapshots'
  , 'sandbox'
  , 'tahoe'
  , 'dx_rollup'
  , 'dx_metadata'
  , 'dx_sandbox'
  , 'dx_csv'
)



-- look into table size
-- based on http://stackoverflow.com/questions/21767780/how-to-find-size-of-database-schema-table-in-redshift
SELECT name AS table_name, ROUND((COUNT(*) / 1024.0),2) as "Size in Gigabytes"
 FROM stv_blocklist
 INNER JOIN
 (SELECT DISTINCT id, name FROM stv_tbl_perm) names
 ON names.id = stv_blocklist.tbl
 GROUP BY name
 ORDER BY "Size in Gigabytes" DESC;


-- See load csv errors
WITH
user_name AS (SELECT 'twitcher' AS user) --change this to whoever loaded the csv

SELECT userid, tbl, starttime, filename, line_number, colname, err_code, err_reason
FROM stl_load_errors
WHERE userid = (SELECT usesysid FROM pg_user WHERE usename=(SELECT user FROM user_name))
;




-- see dist key and sort key of tables
set search_path to '$user', 'public', 'dx_rollup', 'dx_csv', 'dx_sandbox', 'dx_metadata', 'dx_admin';
select schemaname, tablename, "column", type, distkey, sortkey, "notnull"
from pg_table_def
where tablename = 'channel_daily_status'
;




-- See current "tableau" queries (must use twitcher)
-- borrowed from https://stackoverflow.com/questions/24765875/how-does-tableau-run-queries-on-redshift-and-or-why-cant-redshift-display-tab
SELECT username, start_time, run_time_seconds::FLOAT/60 AS run_time_minutes, query
FROM
(
SELECT
    TRIM(' ' FROM usr.usename)                                     AS username
  , MIN(cur.starttime)                              AS start_time
  , DATEDIFF(second, min(cur.starttime), getdate()) AS run_time_seconds
  --, min(cur.row_count)                           AS row_count
  --, min(cur.fetched_rows)                           AS fetched_rows
  , listagg(util_text.text)
    WITHIN GROUP (ORDER BY sequence)                AS query
FROM STV_ACTIVE_CURSORS cur
  JOIN stl_utilitytext util_text
    ON cur.pid = util_text.pid AND cur.xid = util_text.xid
  JOIN pg_user usr
    ON usr.usesysid = cur.userid
GROUP BY usr.usename, util_text.xid
)
ORDER BY 2;



--see current running queries
WITH
users_log AS (
  SELECT usesysid AS user_id, usename::VARCHAR(25) AS user_name, usecreatedb AS flag_create_db, usesuper AS flag_super
  FROM pg_user
)

, user_groups_log AS (
  SELECT usename AS user_name, groname AS group_name
  FROM pg_user, pg_group
  WHERE pg_user.usesysid = ANY(pg_group.grolist)
  AND pg_group.groname in (SELECT DISTINCT pg_group.groname from pg_group)
)

, current_queries_log AS (
  SELECT
    inflight.userid AS user_id
    , inflight.starttime AS start_time
    , DATEDIFF(second, inflight.starttime, getdate()) AS run_time_seconds
    , LISTAGG(util_text.text) WITHIN GROUP (ORDER BY sequence) AS the_query
  FROM stv_inflight AS inflight
  LEFT JOIN stl_utilitytext util_text
    ON inflight.pid = util_text.pid AND inflight.xid = util_text.xid
  GROUP BY 1,2
)

, final_queries_log AS (
  SELECT base.user_id, the_users.user_name, base.start_time, base.the_query
  FROM current_queries_log AS base
  LEFT JOIN users_log AS the_users ON base.user_id = the_users.user_id
)

SELECT * FROM final_queries_log;






-- DEPRECATED
--
-- WITH
-- users_log AS (
--   SELECT usesysid AS user_id, usename::VARCHAR(25) AS user_name, usecreatedb AS flag_create_db, usesuper AS flag_super
--   FROM pg_user
-- )
--
-- , user_groups_log AS (
--   SELECT usename AS user_name, groname AS group_name
--   FROM pg_user, pg_group
--   WHERE pg_user.usesysid = ANY(pg_group.grolist)
--   AND pg_group.groname in (SELECT DISTINCT pg_group.groname from pg_group)
-- )
--
-- , current_queries_log AS (
--   select
--     userid AS user_id
--     , pid
--     , query
--     , starttime AS start_time
--     , text::VARCHAR(500) AS the_query
--   from stv_inflight
-- )
--
-- , final_queries_log AS (
--   SELECT base.user_id, the_users.user_name, base.pid, query, base.start_time, base.the_query
--   FROM current_queries_log AS base
--   LEFT JOIN users_log AS the_users ON base.user_id = the_users.user_id
-- )
--
-- SELECT * FROM final_queries_log;



--get current running queries with full query text
WITH the_data AS (

select stv_recents.user_name, stv_recents.db_name, stl_querytext.query, stl_querytext.sequence, stl_querytext.text
from stv_recents join stl_querytext on stl_querytext.pid = stv_recents.pid
where stv_recents.status = 'Running' order by stl_querytext.query
)

, final_data AS (
  select user_name, db_name, query AS query_id
    , listagg(text , '') within group (order by sequence asc) AS query_text
  from the_data
  GROUP By 1,2,3
)

SELECT user_name, query_id
 , query_text
 --, REPLACE(query_text, '\n', chr(10))
from final_data;


--
-- -- example to replace "\n" with new line?
-- WITH
-- the_constants AS (
--   SELECT 'test\n next line'::VARCHAR(255) AS the_string
-- )
-- SELECT REPLACE(the_string, '\n', ''), the_string
-- FROM the_constants
-- ;






--GET ACTUAL SHEIK TABLE NAME FROM CUBES OR TAHOE
WITH
the_constants AS (
  --SELECT 'cubes.extension_mobile_viewer_funnel_daily'::VARCHAR(MAX) AS full_table_name
  --cubes.extension_mobile_viewer_funnel_daily
  --SELECT 'tahoe.channel_concurrents'::VARCHAR(MAX) AS full_table_name
  SELECT 'dbsnapshots.users'::VARCHAR(MAX) AS full_table_name
  --SELECT 'dbsnapshots.extensions_extension_versions'::VARCHAR(MAX) AS full_table_name

  --SELECT 'spade.minute-watched'::VARCHAR(MAX) AS full_table_name
  --SELECT 'dbsnapshots.extensions_extension_summaries'::VARCHAR(MAX) AS full_table_name
  --SELECT 'metadata.atlas_f_organizer_channel'::VARCHAR(MAX) AS full_table_name
  --SELECT 'metadata.png_whitelist'::VARCHAR(MAX) AS full_table_name
  --SELECT ''::VARCHAR(MAX) AS full_table_name
)
, the_constants_parsed AS (
  SELECT
    split_part(full_table_name,'.',1) as schema_name
    , split_part(full_table_name,'.',2) as table_name
  FROM the_constants
)
, the_view_statement AS (
  SELECT definition
  FROM pg_views
  WHERE schemaname = (SELECT schema_name FROM the_constants_parsed) and viewname = (SELECT table_name FROM the_constants_parsed)
)



--chr(10) is newline character
--https://stackoverflow.com/questions/32367106/redshift-how-to-remove-all-newline-characters-in-a-field
, the_view_statement_parsed AS (
  SELECT
    replace(
      replace(
        split_part(
          split_part(split_part(definition,'FROM',2),'WITH NO SCHEMA BINDING;',1)
          , 'WHERE', 1
        )
      , chr(10),'')
    , '\"','') AS the_real_table
  FROM the_view_statement
)

, final_data_partitioned_table AS (
  SELECT *
    , 'select max(values) AS updated_day from svv_external_partitions where schemaname = \''||TRIM(schema_name)||
    '\' and tablename = \''||TRIM(table_name)||'\';' AS query_to_run_to_check_updated_day
  FROM (
    SELECT
      (SELECT full_table_name FROM the_constants) AS your_table
      , the_real_table
      , split_part(the_real_table,'.',1) as schema_name
      , split_part(the_real_table,'.',2) as table_name
    FROM the_view_statement_parsed
  )
)

, final_data_repalcement_table AS (
  SELECT *
    , 'select location from svv_external_tables where schemaname = \''||TRIM(schema_name)||
    '\' and tablename = \''||TRIM(table_name)||'\';' AS query_to_run_to_check_updated_day

    -- , 'select right(split_part(split_part(location,\''||split_part(your_table,'.',2)||
    -- '\',2),\'T\',1),8) AS updated_day from svv_external_tables where schemaname = \''||TRIM(schema_name)||
    -- '\' and tablename = \''||TRIM(table_name)||'\';' AS query_to_run_to_check_updated_day

    -- , 'select to_date(right(split_part(split_part(location,\''||split_part(your_table,'.',2)||
    -- '\',2),\'T\',1),8), \'yyyymmdd\') AS updated_day from svv_external_tables where schemaname = \''||TRIM(schema_name)||
    -- '\' and tablename = \''||TRIM(table_name)||'\';' AS query_to_run_to_check_updated_day
  FROM (
    SELECT
      (SELECT full_table_name FROM the_constants) AS your_table
      , the_real_table
      , split_part(the_real_table,'.',1) as schema_name
      , split_part(the_real_table,'.',2) as table_name
    FROM the_view_statement_parsed
  )
)

, final_data AS (
  SELECT * FROM final_data_partitioned_table
  UNION SELECT * FROM final_data_repalcement_table
)

SELECT your_table, the_real_table, query_to_run_to_check_updated_day FROM final_data;
