import gspread
from oauth2client.service_account import ServiceAccountCredentials
import csv

scope = ['https://spreadsheets.google.com/feeds',
         'https://www.googleapis.com/auth/drive']

# Get the special crednetials json file from yanghung
credentials = ServiceAccountCredentials.from_json_keyfile_name('/Users/yanghung/Downloads/google_oauth_credentials2.json', scope)
gc = gspread.authorize(credentials)


workbook = gc.open_by_url('https://docs.google.com/spreadsheets/d/1hk7i3qeL63s4jxAItljN__2dejtzZCpMv4SHk3y6Dqs')

sheet_premium_extensions = workbook.worksheet("premium_channel_extensions")
sheet_ugc_extensions = workbook.worksheet("official_content_matched_extensions")

all_values_sheet_premium_extensions = sheet_premium_extensions.get_all_values()
all_values_sheet_ugc_extensions = sheet_ugc_extensions.get_all_values()


csv_filepath_sheet_premium_extensions = '/Users/yanghung/Documents/GitHub/runbook/google_sheets_to_redshift/sheet_premium_extensions.csv'
csv_filepath_sheet_ugc_extensions = '/Users/yanghung/Documents/GitHub/runbook/google_sheets_to_redshift/sheet_ugc_extensions.csv'


with open(csv_filepath_sheet_premium_extensions, mode='w') as the_file_sheet_premium_extensions:
    the_writer = csv.writer(the_file_sheet_premium_extensions, delimiter=',')
    the_writer.writerows(all_values_sheet_premium_extensions)

with open(csv_filepath_sheet_ugc_extensions , mode='w') as the_file_sheet_ugc_extensions :
    the_writer = csv.writer(the_file_sheet_ugc_extensions , delimiter=',', quotechar='"', quoting=csv.QUOTE_ALL)
    the_writer.writerows(all_values_sheet_ugc_extensions )
