import sys
import psycopg2
import os
import traceback
import json
import requests

args = sys.argv

if len(args) < 2:
    print('ERROR: No files were passed into the script')
    sys.exit()


files = args[8:]

#ARGUMENTS NEEDED: user and password

user = args[1]
password = args[2]

if user is None:
    print('ERROR: $my_ldap not defined. Please check your bash profile to see whether it was set up.')
    sys.exit()

if password is None:
    print('ERROR: $PSQL_PASSWORD not defined. Please check your bash profile to see whether it was set up.')

port=int(args[3])
server=args[4]
ssh_server = args[5]


#tunnel = subprocess.Popen(['/bin/bash','ssh','-f','-o','ExitOnForwardFailure=yes','-L', '{}:{}:{}'.format(port,server,port),'{}'.format(ssh_server), 'sleep 30' ])


os.system('killall ssh')
os.system('ssh -fo ExitOnForwardFailure=yes -L {}:{}:{} {} sleep 30'.format(port,server,port,ssh_server))


slack_url='https://hooks.slack.com/services/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'
payload = {"text":"","link_names":1,"mrkdwn":True}

connection = psycopg2.connect(dbname = args[7], user=user,password=password, host = args[6],port = port)
for file in files:
	f = open(file)
	file = file.split('/')[-1]
	info = f.read()
	commands = info.split(';')
	cursor = connection.cursor()
	csv_file = open('results_{}.csv'.format(file.split('.')[0]), 'w')
	results = []
	errors = ''
	for command in commands:
		try:
			if len(command.strip()) == 0:
				continue
			cursor.execute(command)
			print('Finished executing file')
			columns = [column.name for column in cursor.description]
			csv_file.write('{}\n'.format(','.join(columns)))
			while True:
				rows = cursor.fetchmany(5000)
				print(rows)
				if not rows:
					break
				for row in rows:
					csv_file.write('{}\n'.format(','.join([str(e) for e in row])))
				print('Results:\n {}'.format(rows))
		except:
			message = traceback.format_exc()
			if 'empty query' not in message and message not in errors and 'SIGTERM' not in message:
				 errors += 'Command Executed: {}\n'.format(command)+message+'\n'
		connection.commit()
	text= "Hi @{} your script `{}` finished running.".format(user, file)
	if len(errors.strip()) != 0:
		text = "Hi @{} your query `{}` finished running, but there were some errors:\n".format(user,file)
		text += "```{}```\n".format(errors)
	payload['text'] = text
	requests.post(slack_url,data=json.dumps(payload),headers={'Content_Type': 'application/json'})
	csv_file.close()	
connection.close()
