-- [from dallas tester]
-- Our main input metric is # of relevant applications.
-- “Relevant” means 1 user oAuthed in the past 30 days + more than 5 oAuthed users lifetime.



WITH
the_timeframe AS (
SELECT DATE_TRUNC('day', (SYSDATE - INTERVAL '7 hours')) - INTERVAL '31 days' - INTERVAL '0 seconds' AS start_time -- >= 31 days ago
, DATE_TRUNC('day', (SYSDATE - INTERVAL '7 hours')) - INTERVAL '0 days' - INTERVAL '1 seconds' AS end_time -- <= yesterday
)

, oauth_lifetime AS (
SELECT client_id, COUNT(DISTINCT user_id) AS oauth_users_lifetime
FROM logs.oauth_authorize
GROUP BY 1
)

, oauth_30d AS (
SELECT client_id, COUNT(DISTINCT user_id) AS oauth_users_30d
FROM logs.oauth_authorize
WHERE "time">= (SELECT start_time FROM the_timeframe)
AND "time"<= (SELECT end_time FROM the_timeframe)
GROUP BY 1
)


SELECT COUNT(DISTINCT a.client_id) AS num_relevant_apps
FROM oauth_30d AS a
LEFT JOIN oauth_lifetime AS b ON a.client_id = b.client_id
WHERE a.oauth_users_30d>=1 AND b.oauth_users_lifetime>=5
AND a.oauth_users_30d IS NOT NULL AND b.oauth_users_lifetime IS NOT NULL
