-- Calculate overall 5min play sessions per unique device per day for both
-- new to Twitch users and returning to Twitch users in these segments:
--
-- 1. people that have seen AND clicked on an extension
-- 2. people that have seen an extension but never clicked
-- 3. people that have never seen an extension
-- (probably can't segment by new to twitch/returning to twitch users due to sample size right now)

WITH
the_timeframe AS (
SELECT '2017-08-01' AS range_start, '2017-08-31' AS range_end
)
, the_constants_extension_type AS (
SELECT 'video_overlay' AS extension_type
UNION ALL SELECT 'panel' AS extension_type
)
, the_constants_extension_mode_exclude AS (
SELECT 'dashboard' AS extension_mode
UNION ALL SELECT 'config' AS extension_mode
)


, extension_view_video AS (
SELECT
render.device_id, 1 AS view_extension
FROM logs.extension_render AS render
WHERE
render.time>=(SELECT range_start FROM the_timeframe) AND render.time<=(SELECT range_end FROM the_timeframe)   --within the time range
AND render.extension_mode NOT IN (SELECT extension_mode FROM the_constants_extension_mode_exclude)            --make sure this is extensions from channel page
AND render.extension_anchor IN ('video_overlay')
AND render.extension_id NOT IN (SELECT extension_id FROM analysis.extension_exclude_list)                     --list of extension_id to exclude, maintained manually by yanghung
GROUP BY 1
)

, extension_view_panel AS (
SELECT
view.device_id, 1 AS view_extension
FROM logs.extension_view AS view
WHERE
view.time>=(SELECT range_start FROM the_timeframe) AND view.time<=(SELECT range_end FROM the_timeframe)     --within the time range
AND view.extension_mode NOT IN (SELECT extension_mode FROM the_constants_extension_mode_exclude)            --make sure this is extensions from channel page
AND view.extension_anchor IN ('panel')
AND view.pct_view_visible >= 75                                                                             --must be 75% visible to count as view
GROUP BY 1
)

, extension_click AS (
SELECT
click.device_id, 1 AS click_extension
FROM logs.extension_click AS click
WHERE
click.time>=(SELECT range_start FROM the_timeframe) AND click.time<=(SELECT range_end FROM the_timeframe)   --within the time range
AND click.extension_mode NOT IN (SELECT extension_mode FROM the_constants_extension_mode_exclude)           --make sure this is extensions from channel page
AND click.extension_anchor IN (SELECT extension_type FROM the_constants_extension_type)                     --either video or panel extension
AND click.extension_id NOT IN (SELECT extension_id FROM analysis.extension_exclude_list)                    --list of extension_id to exclude, maintained manually by yanghung
GROUP BY 1
)

, extension_interactions AS (
SELECT base.*, NVL(extension_click.click_extension,0) AS click_extension
FROM
(
SELECT device_id, 1 AS view_extension
FROM
(
SELECT * FROM extension_view_video
UNION ALL SELECT * FROM extension_view_panel
)
GROUP BY 1
) AS base
LEFT JOIN extension_click ON base.device_id = extension_click.device_id
)

, five_min_play AS (
SELECT five.device_id, COUNT(1)::FLOAT AS num_five_mp
FROM rollups.five_minute_plays AS five
WHERE five.time>=(SELECT range_start FROM the_timeframe) AND five.time<=(SELECT range_end FROM the_timeframe)   --within the time range
AND platform='web'
GROUP BY 1
)

SELECT view_extension, click_extension, COUNT(DISTINCT device_id) AS num_devices, SUM(num_five_mp) AS total_five_mp, AVG(num_five_mp) AS avg_five_mp
FROM
(
SELECT five.*, NVL(ext.view_extension,0) AS view_extension, NVL(ext.click_extension,0) AS click_extension
FROM five_min_play AS five
LEFT JOIN extension_interactions AS ext ON five.device_id = ext.device_id
)
GROUP BY 1,2
ORDER BY 1,2
