-- logs.notification_sent_server
-- logs.notification_interaction
-- logs.notification_impression

-- the notification type is 'dropsavailable'
-- the campaign_id is unique for each drops campaign message, but maps to different notification_id
-- the target_url lets us determine what the drops campaign is (the redirect_url)

WITH
the_timeframe AS (
SELECT '2017-07-01 00:00:00' AS start_time
, '2017-11-15 00:00:00' AS end_time
, 155528531 AS user_id --a_dot_burr
)

, notification_sent_log AS (
SELECT 'notification_sent_server' AS table, "time", '' device_id, user_id, login, channel_id, channel, campaign_id
, notification_id, '' target_url
FROM logs.notification_sent_server AS base
WHERE base.time>=(SELECT start_time FROM the_timeframe)
AND base.time<(SELECT end_time FROM the_timeframe)
--AND user_id=(SELECT user_id FROM the_timeframe)
AND notification_type='dropsavailable'
)

-- , notification_impression_log AS (
-- SELECT 'notification_impression' AS table, "time", device_id, user_id, login, -1 channel_id, '' channel, '' campaign_id
-- , notification_id, '' target_url
-- FROM logs.notification_impression AS base
-- WHERE base.time>=(SELECT start_time FROM the_timeframe)
-- AND base.time<(SELECT end_time FROM the_timeframe)
-- AND user_id=(SELECT user_id FROM the_timeframe)
-- AND notification_type='dropsavailable'
-- )

, notification_interaction_log AS (
SELECT 'notification_interaction' AS table, "time", device_id, user_id, login, -1 channel_id, '' channel, '' campaign_id
, notification_id, target_url
FROM logs.notification_interaction AS base
WHERE base.time>=(SELECT start_time FROM the_timeframe)
AND base.time<(SELECT end_time FROM the_timeframe)
--AND user_id=(SELECT user_id FROM the_timeframe)
AND notification_type='dropsavailable'
)



SELECT * FROM notification_sent_log
--UNION ALL SELECT * FROM notification_impression_log
UNION ALL SELECT * FROM notification_interaction_log
ORDER BY user_id, "time"
