WITH
the_constants AS (
SELECT '2017-05-24 13:00:00'::timestamp AS start_time
--SELECT '2017-09-06 16:00:00'::timestamp AS start_time_ga
--, '2017-10-03 13:39:00'::timestamp AS end_time
--, '2017-09-22 15:00:00'::timestamp AS end_time
--, DATE_TRUNC('month', SYSDATE)::TIMESTAMP - INTERVAL '1 seconds' AS end_time_last_month
--, '2017-11-06 15:19:00'::TIMESTAMP AS end_time_this_month
, DATE_TRUNC('month', SYSDATE)::TIMESTAMP + INTERVAL '1 month' - INTERVAL '1 seconds' AS end_time_this_month
, 'lgpf9j7y8n1ja9onkb6w7bxfkhk2zl' AS extension_id --OP.GG Summoner
)


-- activation_by_channel
, activate_logs AS (
SELECT 'activate' AS action, extension_id, extension_version, user_id, "time"--, MAX(time) AS last_time_activate
FROM logs.extension_activate
WHERE time>=(SELECT start_time FROM the_constants) AND time<=(SELECT end_time_this_month FROM the_constants)
AND (extension_id=(SELECT extension_id FROM the_constants) OR extension_id='zfh2irvx2jb4s60f02jq0ajm8vwgka')
)
-- deactivation by channel
, deactivate_logs AS (
SELECT 'deactivate' AS action, extension_id, extension_version, user_id, "time"--, MAX(time) AS last_time_deactivate
FROM logs.extension_deactivate
WHERE time>=(SELECT start_time FROM the_constants) AND time<=(SELECT end_time_this_month FROM the_constants)
AND (extension_id=(SELECT extension_id FROM the_constants) OR extension_id='zfh2irvx2jb4s60f02jq0ajm8vwgka')
)
--uninstall by channel is an implicit deactivate
, uninstall_logs AS (
SELECT 'uninstall' AS action, extension_id, extension_version, user_id, "time"--, MAX(time) AS last_time_uninstall
FROM logs.extension_uninstall
WHERE time>=(SELECT start_time FROM the_constants) AND time<=(SELECT end_time_this_month FROM the_constants)
AND (extension_id=(SELECT extension_id FROM the_constants) OR extension_id='zfh2irvx2jb4s60f02jq0ajm8vwgka')
)

SELECT base.*, REPLACE(rel.extension_name,',','') AS extension_name
FROM
(
SELECT * FROM activate_logs
UNION ALL SELECT * FROM deactivate_logs
UNION ALL SELECT * FROM uninstall_logs
) AS base
LEFT JOIN analysis.released_extensions_latest AS rel ON base.extension_id = rel.extension_id
ORDER BY user_id, "time"
