
WITH
the_data AS (
SELECT base.user_id, CASE WHEN partner.inserted_on IS NULL THEN 0 ELSE 1 END AS flag_is_partner
, CASE WHEN affiliate.channel_id IS NULL THEN 0 ELSE 1 END AS flag_is_affiliate
FROM analysis.dsds138_0 AS base
LEFT JOIN analysis.sitedb_partner_channels partner ON base.user_id = partner.user_id
LEFT JOIN analysis.current_affiliates affiliate ON base.user_id = affiliate.channel_id
)

SELECT *
, CASE WHEN flag_is_partner=1 THEN 'partner'
WHEN flag_is_affiliate=1 THEN 'affiliate'
ELSE 'none'
END AS status
FROM the_data
