
WITH

the_constants AS (
SELECT 14836307 AS user_id
)
, funnel0 AS (
SELECT DATE(time) AS the_day, user_id, channel_status
, MAX(CASE WHEN action='0. view_extension_manager' THEN 1 ELSE 0 END) AS step_0_view_extension_manager
FROM analysis.dsds145_0
--WHERE user_id=(SELECT user_id FROM the_constants) --trumpsc
GROUP BY 1,2,3
)


, funnel1 AS (
SELECT DATE(time) AS the_day, user_id, channel_status, extension_id, extension_name, extension_type, extension_anchor
, MAX(CASE WHEN action='1. view_extension_detail' THEN 1 ELSE 0 END) AS step_1_view_extension_detail
, MAX(CASE WHEN action='2. install_extension' THEN 1 ELSE 0 END) AS step_2_install_extension
, MAX(CASE WHEN action='3. activate_extension' THEN 1 ELSE 0 END) AS step_3_activate_extension
FROM analysis.dsds145_0
WHERE
action IN ('1. view_extension_detail','2. install_extension','3. activate_extension')
--AND user_id=(SELECT user_id FROM the_constants) --trumpsc
GROUP BY 1,2,3,4,5,6,7
)

, funnel_by_user_day AS (
SELECT fun0.the_day, fun0.user_id, fun1.extension_id, fun1.extension_name, fun1.extension_type, fun1.extension_anchor
, fun0.step_0_view_extension_manager
, fun1.step_1_view_extension_detail, fun1.step_2_install_extension, fun1.step_3_activate_extension
FROM funnel0 AS fun0
LEFT JOIN funnel1 AS fun1 ON fun0.the_day = fun1.the_day AND fun0.user_id = fun1.user_id
)


SELECT the_day, extension_id, REPLACE(extension_name,',','') AS extension_name, extension_type, extension_anchor
, SUM(step_0_view_extension_manager) AS num_step_0_view_extension_manager
, SUM(step_1_view_extension_detail) AS num_step_1_view_extension_detail
, SUM(step_2_install_extension) AS num_step_2_install_extension
, SUM(step_3_activate_extension) AS num_step_3_activate_extension
FROM funnel_by_user_day
WHERE extension_id IS NOT NULL
GROUP BY 1,2,3,4,5
ORDER BY 2,1
