WITH
the_constants AS (
SELECT '2017-09-06 00:00:00'::TIMESTAMP AS start_time
, '2017-11-29 00:00:00'::TIMESTAMP AS end_time
-- SELECT DATEDIFF(day, start_time, end_time)*10 AS dedicated_streamer_mb FROM the_constants
-- SELECT DATEDIFF(day, (SELECT start_time FROM the_constants), (SELECT end_time FROM the_constants)) AS final
, DATE_TRUNC('day', (SYSDATE - INTERVAL '7 hours'))::timestamp - INTERVAL '30 days' AS start_time_rolling_30
, DATE_TRUNC('day', (SYSDATE - INTERVAL '7 hours'))::timestamp  - INTERVAL '1 seconds' AS end_time_rolling_30
)

, dedicated_streamer_list AS (
SELECT *
FROM (
  SELECT channel_id, SUM(1)::FLOAT / DATEDIFF(day, (SELECT start_time FROM the_constants), (SELECT end_time FROM the_constants))::FLOAT AS mb_per_day
  FROM logs.channel_concurrents
  WHERE time>=(SELECT start_time FROM the_constants) AND time<=(SELECT end_time FROM the_constants)
  GROUP BY 1
)
WHERE mb_per_day>=10 --dedicated: at least 10 mins per day on avg
--WHERE mb_per_day<10 AND mb_per_day>=1 --not dedicated streamer
)

, view_extention_mgr_list AS (
SELECT DISTINCT user_id
FROM analysis.dsds145_0
WHERE action='0. view_extension_manager'
AND time>=(SELECT start_time FROM the_constants) AND time<(SELECT end_time FROM the_constants)
)

SELECT SUM(1) AS total_dedicated_streamer, SUM(flag_did_view) AS total_did_view_extension_mgr, SUM(flag_did_view)::FLOAT/SUM(1)::FLOAT AS the_ratio
FROM (
  SELECT base.channel_id, CASE WHEN view.user_id IS NOT NULL THEN 1 ELSE 0 END AS flag_did_view
  FROM dedicated_streamer_list AS base
  LEFT JOIN view_extention_mgr_list AS view ON base.channel_id = view.user_id
)
