WITH

the_dates AS (
SELECT DATE_TRUNC('week', (SYSDATE - INTERVAL '7 hours')) - INTERVAL '2 days' AS the_date
UNION ALL
SELECT DATE_TRUNC('week', (SYSDATE - INTERVAL '7 hours')) - INTERVAL '2 days' - INTERVAL '1 week' AS the_date
UNION ALL
SELECT DATE_TRUNC('week', (SYSDATE - INTERVAL '7 hours')) - INTERVAL '2 days' - INTERVAL '2 week' AS the_date
UNION ALL
SELECT DATE_TRUNC('week', (SYSDATE - INTERVAL '7 hours')) - INTERVAL '2 days' - INTERVAL '3 week' AS the_date
UNION ALL
SELECT DATE_TRUNC('week', (SYSDATE - INTERVAL '7 hours')) - INTERVAL '2 days' - INTERVAL '4 week' AS the_date
UNION ALL
SELECT DATE_TRUNC('week', (SYSDATE - INTERVAL '7 hours')) - INTERVAL '2 days' - INTERVAL '5 week' AS the_date
UNION ALL
SELECT DATE_TRUNC('week', (SYSDATE - INTERVAL '7 hours')) - INTERVAL '2 days' - INTERVAL '6 week' AS the_date
UNION ALL
SELECT DATE_TRUNC('week', (SYSDATE - INTERVAL '7 hours')) - INTERVAL '2 days' - INTERVAL '7 week' AS the_date
UNION ALL
SELECT DATE_TRUNC('week', (SYSDATE - INTERVAL '7 hours')) - INTERVAL '2 days' - INTERVAL '8 week' AS the_date
)

, week0 AS (
  SELECT base.the_day, base.extension_id, rel.extension_url, REPLACE(rel.extension_author_name,',','') AS extension_author_name, REPLACE(rel.extension_name,',','') AS extension_name
  , COUNT(DISTINCT base.channel_id) AS channels--, SUM(CASE WHEN bool_extension_activated THEN 1 ELSE 0 END) AS active_extensions
  FROM analysis.dsds134_test_extension_daily_channel_presence AS base
  LEFT JOIN analysis.released_extensions_latest AS rel ON base.extension_id = rel.extension_id
  WHERE bool_extension_activated
  AND the_day = DATE_TRUNC('week', (SYSDATE - INTERVAL '7 hours')) - INTERVAL '2 days'
  GROUP BY 1,2,3,4,5
)

, week1 AS (
  SELECT base.the_day, base.extension_id, rel.extension_url, REPLACE(rel.extension_author_name,',','') AS extension_author_name, REPLACE(rel.extension_name,',','') AS extension_name
  , COUNT(DISTINCT base.channel_id) AS channels--, SUM(CASE WHEN bool_extension_activated THEN 1 ELSE 0 END) AS active_extensions
  FROM analysis.dsds134_test_extension_daily_channel_presence AS base
  LEFT JOIN analysis.released_extensions_latest AS rel ON base.extension_id = rel.extension_id
  WHERE bool_extension_activated
  AND the_day = DATE_TRUNC('week', (SYSDATE - INTERVAL '7 hours')) - INTERVAL '2 days' - INTERVAL '1 week'
  GROUP BY 1,2,3,4,5
)

, week2 AS (
  SELECT base.the_day, base.extension_id, rel.extension_url, REPLACE(rel.extension_author_name,',','') AS extension_author_name, REPLACE(rel.extension_name,',','') AS extension_name
  , COUNT(DISTINCT base.channel_id) AS channels--, SUM(CASE WHEN bool_extension_activated THEN 1 ELSE 0 END) AS active_extensions
  FROM analysis.dsds134_test_extension_daily_channel_presence AS base
  LEFT JOIN analysis.released_extensions_latest AS rel ON base.extension_id = rel.extension_id
  WHERE bool_extension_activated
  AND the_day = DATE_TRUNC('week', (SYSDATE - INTERVAL '7 hours')) - INTERVAL '2 days' - INTERVAL '2 week'
  GROUP BY 1,2,3,4,5
)

, week3 AS (
  SELECT base.the_day, base.extension_id, rel.extension_url, REPLACE(rel.extension_author_name,',','') AS extension_author_name, REPLACE(rel.extension_name,',','') AS extension_name
  , COUNT(DISTINCT base.channel_id) AS channels--, SUM(CASE WHEN bool_extension_activated THEN 1 ELSE 0 END) AS active_extensions
  FROM analysis.dsds134_test_extension_daily_channel_presence AS base
  LEFT JOIN analysis.released_extensions_latest AS rel ON base.extension_id = rel.extension_id
  WHERE bool_extension_activated
  AND the_day = DATE_TRUNC('week', (SYSDATE - INTERVAL '7 hours')) - INTERVAL '2 days' - INTERVAL '3 week'
  GROUP BY 1,2,3,4,5
)

, week4 AS (
  SELECT base.the_day, base.extension_id, rel.extension_url, REPLACE(rel.extension_author_name,',','') AS extension_author_name, REPLACE(rel.extension_name,',','') AS extension_name
  , COUNT(DISTINCT base.channel_id) AS channels--, SUM(CASE WHEN bool_extension_activated THEN 1 ELSE 0 END) AS active_extensions
  FROM analysis.dsds134_test_extension_daily_channel_presence AS base
  LEFT JOIN analysis.released_extensions_latest AS rel ON base.extension_id = rel.extension_id
  WHERE bool_extension_activated
  AND the_day = DATE_TRUNC('week', (SYSDATE - INTERVAL '7 hours')) - INTERVAL '2 days' - INTERVAL '4 week'
  GROUP BY 1,2,3,4,5
)

, week5 AS (
  SELECT base.the_day, base.extension_id, rel.extension_url, REPLACE(rel.extension_author_name,',','') AS extension_author_name, REPLACE(rel.extension_name,',','') AS extension_name
  , COUNT(DISTINCT base.channel_id) AS channels--, SUM(CASE WHEN bool_extension_activated THEN 1 ELSE 0 END) AS active_extensions
  FROM analysis.dsds134_test_extension_daily_channel_presence AS base
  LEFT JOIN analysis.released_extensions_latest AS rel ON base.extension_id = rel.extension_id
  WHERE bool_extension_activated
  AND the_day = DATE_TRUNC('week', (SYSDATE - INTERVAL '7 hours')) - INTERVAL '2 days' - INTERVAL '5 week'
  GROUP BY 1,2,3,4,5
)

, week6 AS (
  SELECT base.the_day, base.extension_id, rel.extension_url, REPLACE(rel.extension_author_name,',','') AS extension_author_name, REPLACE(rel.extension_name,',','') AS extension_name
  , COUNT(DISTINCT base.channel_id) AS channels--, SUM(CASE WHEN bool_extension_activated THEN 1 ELSE 0 END) AS active_extensions
  FROM analysis.dsds134_test_extension_daily_channel_presence AS base
  LEFT JOIN analysis.released_extensions_latest AS rel ON base.extension_id = rel.extension_id
  WHERE bool_extension_activated
  AND the_day = DATE_TRUNC('week', (SYSDATE - INTERVAL '7 hours')) - INTERVAL '2 days' - INTERVAL '6 week'
  GROUP BY 1,2,3,4,5
)

, week7 AS (
  SELECT base.the_day, base.extension_id, rel.extension_url, REPLACE(rel.extension_author_name,',','') AS extension_author_name, REPLACE(rel.extension_name,',','') AS extension_name
  , COUNT(DISTINCT base.channel_id) AS channels--, SUM(CASE WHEN bool_extension_activated THEN 1 ELSE 0 END) AS active_extensions
  FROM analysis.dsds134_test_extension_daily_channel_presence AS base
  LEFT JOIN analysis.released_extensions_latest AS rel ON base.extension_id = rel.extension_id
  WHERE bool_extension_activated
  AND the_day = DATE_TRUNC('week', (SYSDATE - INTERVAL '7 hours')) - INTERVAL '2 days' - INTERVAL '7 week'
  GROUP BY 1,2,3,4,5
)

, week8 AS (
  SELECT base.the_day, base.extension_id, rel.extension_url, REPLACE(rel.extension_author_name,',','') AS extension_author_name, REPLACE(rel.extension_name,',','') AS extension_name
  , COUNT(DISTINCT base.channel_id) AS channels--, SUM(CASE WHEN bool_extension_activated THEN 1 ELSE 0 END) AS active_extensions
  FROM analysis.dsds134_test_extension_daily_channel_presence AS base
  LEFT JOIN analysis.released_extensions_latest AS rel ON base.extension_id = rel.extension_id
  WHERE bool_extension_activated
  AND the_day = DATE_TRUNC('week', (SYSDATE - INTERVAL '7 hours')) - INTERVAL '2 days' - INTERVAL '8 week'
  GROUP BY 1,2,3,4,5
)

SELECT week0.extension_id, week0.extension_url, week0.extension_author_name, week0.extension_name
, NVL(week8.channels, 0) AS week_t_minus8_channels
, NVL(week7.channels, 0) AS week_t_minus7_channels
, NVL(week6.channels, 0) AS week_t_minus6_channels
, NVL(week5.channels, 0) AS week_t_minus5_channels
, NVL(week4.channels, 0) AS week_t_minus4_channels
, NVL(week3.channels, 0) AS week_t_minus3_channels
, NVL(week2.channels, 0) AS week_t_minus2_channels
, NVL(week1.channels, 0) AS week_t_minus1_channels
, NVL(week0.channels, 0) AS week_t_minus0_channels
FROM week0
LEFT JOIN week1 ON week0.extension_id=week1.extension_id --AND week0.extension_version=week1.extension_version
LEFT JOIN week2 ON week0.extension_id=week2.extension_id --AND week0.extension_version=week2.extension_version
LEFT JOIN week3 ON week0.extension_id=week3.extension_id --AND week0.extension_version=week3.extension_version
LEFT JOIN week4 ON week0.extension_id=week4.extension_id --AND week0.extension_version=week4.extension_version
LEFT JOIN week5 ON week0.extension_id=week5.extension_id --AND week0.extension_version=week5.extension_version
LEFT JOIN week6 ON week0.extension_id=week6.extension_id --AND week0.extension_version=week6.extension_version
LEFT JOIN week7 ON week0.extension_id=week7.extension_id --AND week0.extension_version=week7.extension_version
LEFT JOIN week8 ON week0.extension_id=week8.extension_id --AND week0.extension_version=week8.extension_version
WHERE week0.extension_name IS NOT NULL
ORDER BY 13 DESC
