WITH
the_extension_states AS (
  SELECT 'Testing' AS state, '1. Local Testing' AS the_stage
  UNION ALL SELECT 'Assets Uploaded' AS state, '2. Hosted Testing' AS the_stage
  UNION ALL SELECT 'In Review' AS state, '3. In Review' AS the_stage
  UNION ALL SELECT 'Approved' AS state, '4. Approved' AS the_stage
  UNION ALL SELECT 'Released' AS state, '5. Released' AS the_stage
)

, extension_lifecycle_logs AS (
  SELECT base.user_id, base.extension_id, base.extension_version, tes.the_stage, MAX("time") AS "time"
  FROM tahoe.extension_lifecycle AS base
  RIGHT JOIN the_extension_states AS tes ON base.state=tes.state
  WHERE time>='2017-09-06 16:00:00' --the time when extensions was in GA launch
  GROUP BY 1,2,3,4
)

, extension_create_logs AS (
  SELECT base.user_id, base.extension_id, base.extension_version, tes.the_stage, MAX("time") AS "time"
  FROM tahoe.extension_create AS base
  RIGHT JOIN the_extension_states AS tes ON base.state=tes.state
  WHERE time>='2017-09-06 16:00:00' --the time when extensions was in GA launch
  GROUP BY 1,2,3,4
)

, the_extension_logs AS (
  SELECT * FROM extension_create_logs
  UNION ALL SELECT * FROM extension_lifecycle_logs
)

, final_data AS (
  SELECT user_id, extension_id, extension_version, the_stage AS latest_stage, "time"
  FROM (
    SELECT *, MAX("time") OVER (PARTITION BY extension_id, extension_version) AS latest_stage_time
    FROM the_extension_logs
  )
  WHERE latest_stage_time = "time"
)

SELECT * FROM final_data
ORDER BY extension_id, extension_version, "time"
