--   rows  | count  | minmb |  maxmb
-- --------+--------+-------+---------
--  676182 | 676182 |    10 | 19425.8



DROP TABLE IF EXISTS    analysis.dsds155_dedicated_streamer_list;
CREATE TABLE    analysis.dsds155_dedicated_streamer_list    AS

WITH
the_constants AS (
  SELECT '2018-01-24'::TIMESTAMP AS analysis_date
)
, the_time_constants AS (
  SELECT
    date::TIMESTAMP AS the_date
    , date::TIMESTAMP - INTERVAL '29 days' AS start_time_rolling_30 --Greater Than Equal To (>=) this timestamp
    , date::TIMESTAMP + INTERVAL '1 days' - INTERVAL '0 seconds' AS end_time_rolling_30 -- Less Than (<) this timestamp
    , DATEDIFF('hours', date::TIMESTAMP - INTERVAL '29 days', date::TIMESTAMP + INTERVAL '1 days' - INTERVAL '0 seconds')::float/24 AS the_days_difference
  FROM metadata.date
  WHERE date=(SELECT analysis_date FROM the_constants)
)
, list_dedicated_streamer AS (
  SELECT *
  FROM (
    SELECT tc.the_date, cc.channel_id, SUM(1)::float / 30 AS mb_per_day
    FROM logs.channel_concurrents AS cc
    LEFT JOIN the_time_constants AS tc ON 1=1
    WHERE time>=(SELECT start_time_rolling_30 FROM the_time_constants) AND time<(SELECT end_time_rolling_30 FROM the_time_constants)
    GROUP BY 1,2
  )
  WHERE mb_per_day>=10
)

SELECT base.the_date AS analysis_date, base.channel_id AS user_id, base.mb_per_day
FROM list_dedicated_streamer AS base


-- SELECT COUNT(1) AS rows, COUNT(DISTINCT user_id), MIN(mb_per_day) AS minmb, MAX(mb_per_day) AS maxmb
-- FROM analysis.dsds155_dedicated_streamer_list
