--Released Extensions row 9
--https://docs.google.com/spreadsheets/d/1sxkI3v3w5dh4VhbE9ur14ys-iLAsALcg-Fp10VA3igA/edit?ts=5a399fb0#gid=246267467

WITH

the_basetable_date AS (
  SELECT
    DATE_TRUNC('month', date) AS the_month, MIN(date) AS start_date, MAX(date) AS end_date
  FROM metadata.date
  WHERE date>='2017-10-01' AND date<'2018-01-01'
  GROUP BY 1
)
SELECT base.the_month, base.start_date, base.end_date, COUNT(DISTINCT rel.extension_id) AS released_extensions
FROM the_basetable_date AS base
LEFT JOIN rollups.extension_daily_channel_presence AS dcp ON base.end_date=dcp.the_day
--WHERE dcp.extension_id IN (SELECT extension_id FROM analysis.released_extensions_latest)
RIGHT JOIN analysis.released_extensions_latest AS rel ON dcp.extension_id = rel.extension_id
GROUP BY 1,2,3
ORDER BY 1,2,3

--
-- --DEPRECATE: THIS IS NUMBER OF ACTIVATED EXTENSIONS
-- WITH
--
-- the_basetable_date AS (
--   SELECT
--     DATE_TRUNC('month', date) AS the_month, MIN(date) AS start_date, MAX(date) AS end_date
--   FROM metadata.date
--   WHERE date>='2017-10-01' AND date<='2017-12-18'
--   GROUP BY 1
-- )
--
-- SELECT base.the_month, base.start_date, base.end_date, SUM(CASE WHEN bool_extension_activated THEN 1 ELSE 0 END) AS active_extensions
-- FROM the_basetable_date AS base
-- LEFT JOIN rollups.extension_daily_channel_presence AS dcp ON base.end_date=dcp.the_day
-- --WHERE dcp.extension_id IN (SELECT extension_id FROM analysis.released_extensions_latest)
-- RIGHT JOIN analysis.released_extensions_latest AS rel ON dcp.extension_id = rel.extension_id
-- GROUP BY 1,2,3
-- ORDER BY 1,2,3

--
-- SELECT base.the_day
-- FROM rollups.extension_daily_channel_presence AS base
-- RIGHT JOIN analysis.released_extension_latest AS rel
