--# of Unique Devices (Web only) in Dedicated channel row 17 (all devices last 30 days)
--https://docs.google.com/spreadsheets/d/1sxkI3v3w5dh4VhbE9ur14ys-iLAsALcg-Fp10VA3igA/edit?ts=5a399fb0#gid=246267467


-- Dedicated broadcasters are defined as broadcasters who has streamed at least 10 minutes per day on average in a given time period.

WITH
the_timeframe AS (
SELECT '2017-05-01 00:00:00'::timestamp AS start_time_extensions
, DATE_TRUNC('day','2018-01-07 23:59:59'::timestamp) - INTERVAL '29 day' AS start_time
, '2018-01-07 23:59:59'::timestamp AS end_time
)

, dedicated_streamer_list AS (
  SELECT *
  FROM (
    SELECT channel_id, SUM(1)::float / DATE_PART(day, LAST_DAY(MAX(time))) AS mb_per_day
    FROM logs.channel_concurrents
    WHERE time>=(SELECT start_time FROM the_timeframe) AND time<=(SELECT end_time FROM the_timeframe)
    GROUP BY 1
  )
  WHERE mb_per_day>=10
)

, final_data AS (
  SELECT platform, COUNT(DISTINCT device_id) AS devices, COUNT(DISTINCT channel_id) AS dedicated_channels, COUNT(DISTINCT device_id)::float/COUNT(DISTINCT channel_id)::float AS devices_per_dedicated_channel
  FROM logs."video-play"
  WHERE channel_id IN (SELECT channel_id FROM dedicated_streamer_list)
  AND time>=(SELECT start_time FROM the_timeframe) AND time<=(SELECT end_time FROM the_timeframe)
  --AND platform='web'
  GROUP BY 1
  ORDER BY 1
)

SELECT * FROM final_data
