
WITH
play_sessions_log AS (
  SELECT ps.start_time AS time, ps.platform, ps.player, ps.num_minutes
  FROM rollups.play_sessions AS ps
  WHERE ps.start_time>='2016-01-01'::timestamp AND ps.start_time<'2018-01-01'::timestamp
)

, final_data AS (
  SELECT DATE_TRUNC('month', time) AS month_group
  , CASE
WHEN platform='web' AND player='site' THEN 'desktop_web'
WHEN platform='web' AND player='embed' THEN 'desktop_web_embed_player'
WHEN platform='android' AND player IS NULL THEN 'android'
WHEN platform='curse' AND player='curse' THEN 'twitch_app'
WHEN platform='ios' AND player IS NULL THEN 'ios'
WHEN platform='android' AND player='android' THEN 'android'
WHEN platform='mobile_web' AND player='popout' THEN 'mobile_web'
WHEN platform='playstation' AND player='ps4_app' THEN 'playstation'
WHEN platform='web' AND player='frontpage' THEN 'desktop_web_front_page'
WHEN platform='web' AND player='dashboard' THEN 'desktop_web'
WHEN platform='ios' AND player='ipad_t' THEN 'ios'
WHEN platform='android' AND player='firetv' THEN 'tv_apps'
WHEN platform='ios' AND player='iphone_t' THEN 'ios'
WHEN platform='web' AND player='popout' THEN 'desktop_web'
WHEN platform='android' AND player='firetv_stick' THEN 'tv_apps'
WHEN platform='android' AND player='androidtv' THEN 'tv_apps'
WHEN platform='mobile_web' AND player='embed' THEN 'mobile_web_embed_player'
WHEN platform='android' AND player='android_pip' THEN 'android'
WHEN platform='mobile_web' AND player='site' THEN 'mobile_web'
WHEN platform='playstation' AND player='ps3_app' THEN 'playstation'
WHEN platform='web' AND player='twitch_everywhere' THEN 'desktop_web_embed_player'
WHEN platform='android' AND player='amazon' THEN 'android'
WHEN platform='android' AND player='mobile_live_preview' THEN 'android'
WHEN platform='playstation' AND player='vita_app' THEN 'playstation'
WHEN platform='web' AND player='highlighter' THEN 'desktop_web'
WHEN platform='mobile_web' AND player='frontpage' THEN 'mobile_web_front_page'
WHEN platform='android' AND player='clips' THEN 'android'
WHEN platform='mobile_web' AND player='facebook' THEN 'mobile_web'
WHEN platform='mobile_web' AND player='dashboard' THEN 'mobile_web'
WHEN platform='mobile_web' AND player='twitch_everywhere' THEN 'mobile_web_embed_player'
WHEN platform='playstation' AND player='pstv_app' THEN 'playstation'
WHEN platform='mobile_web' AND player='twitter' THEN 'mobile_web'
WHEN platform='ios' AND player='ipad_t_pip' THEN 'ios'
WHEN platform='web' AND player='twilight' THEN 'desktop_web'
WHEN platform='android' AND player='nvidia shield' THEN 'android'
WHEN platform='web' AND player='facebook' THEN 'desktop_web'
WHEN platform='web' AND player='creative' THEN 'desktop_web'
WHEN platform='mobile_web' AND player='highlighter' THEN 'mobile_web'
WHEN platform='web' AND player='twitter' THEN 'desktop_web'
WHEN platform='mobile_web' AND player='twilight' THEN 'mobile_web'
WHEN platform='web' AND player='amazon_live' THEN 'desktop_web'
WHEN platform='mobile_web' AND player='amazon_live' THEN 'mobile_web'
WHEN platform='web' AND player='autoplay=true' THEN 'desktop_web'
WHEN platform='web' AND player IS NULL THEN 'desktop_web'
WHEN platform='web' AND player='imdb' THEN 'desktop_web'
WHEN platform='android' AND player='channel_clips' THEN 'android'
WHEN platform='mobile_web' AND player='clips' THEN 'mobile_web'
WHEN platform='android' AND player='ouya' THEN 'android'
WHEN platform='mobile_web' AND player='creative' THEN 'mobile_web'
WHEN platform IS NULL AND player='site' THEN 'desktop_web'
WHEN platform='web' AND player='clips' THEN 'desktop_web'
WHEN platform='mobile_web' AND player='imdb' THEN 'mobile_web'
WHEN platform='mobile_web' AND player='facebookautoplay' THEN 'mobile_web'
WHEN platform='mobile_web' AND player IS NULL THEN 'mobile_web'
WHEN platform='android' AND player='clips_deeplink' THEN 'android'
WHEN platform='web' AND player='site_mini' THEN 'desktop_web'
WHEN platform='mobile_web' AND player='autoplay=true' THEN 'mobile_web'
WHEN platform='web' AND player='clips_embed' THEN 'desktop_web'
WHEN platform='mobile_web' AND player='clips_embed' THEN 'mobile_web'
WHEN platform='web' AND player='twitch' THEN 'desktop_web'
WHEN platform='web' AND player='clips-embed' THEN 'desktop_web'
WHEN platform='web' AND player='telegram' THEN 'desktop_web'
WHEN platform='web' AND player='bnet' THEN 'desktop_web'
WHEN platform='web' AND player='feed' THEN 'desktop_web'
WHEN platform='web' AND player='face' THEN 'desktop_web'
WHEN platform='android' AND player='clips_game' THEN 'android'
WHEN platform='mobile_web' AND player='telegram' THEN 'mobile_web'
WHEN platform='web' AND player='channel_clips' THEN 'desktop_web'
WHEN platform='web' AND player='twitchweb' THEN 'desktop_web'
WHEN platform='android' AND player='clips_pulse' THEN 'android'
WHEN platform='web' AND player='twitch_everywhere_test' THEN 'desktop_web_embed_player'
WHEN platform='curse' AND player IS NULL THEN 'twitch_app'
WHEN platform='mobile_web' AND player='feed' THEN 'mobile_web'
WHEN platform IS NULL AND player='android' THEN 'android'
WHEN platform IS NULL AND player='iphone_t' THEN 'ios'
WHEN platform IS NULL AND player='embed' THEN 'desktop_web_embed_player'
WHEN platform IS NULL AND player='ipad_t' THEN 'ios'
WHEN platform IS NULL AND player='popout' THEN 'desktop_web'
WHEN platform IS NULL AND player='ps4_app' THEN 'playstation'
WHEN platform IS NULL AND player='frontpage' THEN 'desktop_web'
WHEN platform IS NULL AND player='android_pip' THEN 'android'
WHEN platform IS NULL AND player='web' THEN 'desktop_web'
WHEN platform IS NULL AND player='amazon' THEN 'desktop_web'
WHEN platform='web' AND player='web' THEN 'desktop_web'
WHEN platform IS NULL AND player='firetv_stick' THEN 'tv_apps'
WHEN platform IS NULL AND player='androidtv' THEN 'tv_apps'
WHEN platform IS NULL AND player='facebook' THEN 'desktop_web'
WHEN platform IS NULL AND player='firetv' THEN 'tv_apps'
WHEN platform='web' AND player='chromecast' THEN 'tv_apps'
WHEN platform='web' AND player='curse' THEN 'twitch_app'
WHEN platform IS NULL AND player='creative' THEN 'desktop_web'
WHEN platform IS NULL AND player='ps3_app' THEN 'playstation'
WHEN platform IS NULL AND player='ipad_t_pip' THEN 'ios'
WHEN platform IS NULL AND player='chromecast' THEN 'tv_apps'
WHEN platform IS NULL AND player='highlighter' THEN 'desktop_web'
WHEN platform='mobile_web' AND player='site_mini' THEN 'mobile_web'
WHEN platform IS NULL AND player='nvidia shield' THEN 'tv_apps'
WHEN platform='mobile_web' AND player='chromecast' THEN 'tv_apps'
WHEN platform='web' AND player='other' THEN 'desktop_web'
WHEN platform='android' AND player='clips_embed' THEN 'android'
WHEN platform IS NULL AND player='ouya' THEN 'tv_apps'
WHEN platform='web' AND player='clips_game' THEN 'desktop_web'
WHEN platform='mobile_web' AND player='channel_clips' THEN 'mobile_web'
WHEN platform='web' AND player='amazon_vse_test' THEN 'desktop_web'
WHEN platform IS NULL AND player='clips' THEN 'desktop_web'
WHEN platform='web' AND player='html5' THEN 'desktop_web'
WHEN platform='mobile_web' AND player='curse' THEN 'twitch_app'
WHEN platform IS NULL AND player='html5' THEN 'desktop_web'
WHEN platform IS NULL AND player='vita_app' THEN 'playstation'
WHEN platform IS NULL AND player='pstv_app' THEN 'playstation'
WHEN platform='mobile_web' AND player='clips_game' THEN 'mobile_web'
WHEN platform IS NULL AND player='gamestick' THEN 'tv_apps'
WHEN platform='ios' AND player='iphone_t_pip' THEN 'ios'
WHEN platform='web' AND player='facefook' THEN 'desktop_web'
WHEN platform='playstation' AND player IS NULL THEN 'playstation'
  ELSE 'unknown' END AS the_platform
  , SUM(num_minutes)::float/60 AS hrs_watched
  FROM play_sessions_log
  GROUP BY 1,2
)

SELECT * FROM final_data
ORDER BY 1,2
