-- Hey Yang,
--
-- As a follow up from our work creating our dedicated streamer output goal, Ivan had a follow up about how extension usage may differ across various broadcaster size cohorts. I can imagine two ways we could slice the data to get insight into this:
--
-- Slice by % of total HW that have an extension active
-- Slice by % of broadcasters with an extension active across broadcaster tiers
-- Ivan can comment on prioritization of this request relative to other work on your plate.
--
-- Specific request from Ivan:
--
-- "Do you have a POV on whether we will get greater or lesser penetration than average among our most-watched broadcasters?
-- I ask because it seems likely that top broadcasters would generally be early adopters and would therefore be more penetrated than the average.
-- Have we looked at whether that has been true so far?"


WITH
the_constants AS (
  SELECT '2018-01-18'::TIMESTAMP - INTERVAL '29 days' AS start_time, '2018-01-18'::TIMESTAMP AS end_time
)
--get list of channels with extension activated on a specific date
, meta_channels_with_extensions AS (
  SELECT the_day AS the_date, channel_id, 1 AS flag_is_activated
  FROM rollups.extension_daily_channel_presence
  WHERE bool_extension_activated
  AND the_day=(SELECT end_time FROM the_constants)
  GROUP BY 1,2
)

, mw_last_30d_by_channel AS (
  SELECT channel_id, SUM(mw_total) AS mw_total
  FROM analysis.agg_daily_minutes_watched_by_channel
  WHERE "day">=(SELECT start_time FROM the_constants)
  AND "day"<=(SELECT end_time FROM the_constants)
  GROUP BY 1
)
, final_data AS (
  SELECT base.channel_id, base.mw_total, NVL(mcwe.flag_is_activated, 0) AS flag_is_activated
  FROM mw_last_30d_by_channel AS base
  LEFT JOIN meta_channels_with_extensions AS mcwe ON base.channel_id = mcwe.channel_id
)

SELECT SUM(CASE WHEN flag_is_activated=1 THEN mw_total ELSE 0 END) AS mw_by_extension_active_channels, SUM(mw_total) AS mw_all_channels
, SUM(CASE WHEN flag_is_activated=1 THEN mw_total ELSE 0 END)::FLOAT/60 AS hw_by_extension_active_channels, SUM(mw_total)::FLOAT/60 AS hw_all_channels
, SUM(CASE WHEN flag_is_activated=1 THEN mw_total ELSE 0 END)::FLOAT / SUM(mw_total)::FLOAT AS pct_mw_by_extension_active_channels
FROM final_data
