WITH
the_constants AS (
SELECT '2017-05-24 13:00:00'::timestamp AS start_time --go as far back as we have extensions data for
-- , '2018-01-23 15:17:00'::TIMESTAMP AS end_time
-- , '2018-01-24 15:34:00'::TIMESTAMP AS end_time
-- , '2018-01-25 16:18:00'::TIMESTAMP AS end_time
-- , '2018-01-26 16:06:00'::TIMESTAMP AS end_time
-- , '2018-01-30 10:03:00'::TIMESTAMP AS end_time
--, '2018-02-05 18:01:00'::TIMESTAMP AS end_time
, '2018-02-07 15:15:00'::TIMESTAMP AS end_time
)
--installs by channel
, install_logs AS (
SELECT * FROM (
SELECT *, MAX(last_time_install) OVER (PARTITION BY user_id, extension_id) AS max_last_time_install
FROM (
SELECT extension_id, extension_version, user_id, MAX(time) AS last_time_install
FROM logs.extension_install
WHERE time>=(SELECT start_time FROM the_constants) AND time<=(SELECT end_time FROM the_constants)
GROUP BY 1,2,3
))
WHERE last_time_install = max_last_time_install
)
--uninstall by channel
, uninstall_logs AS (
SELECT extension_id, user_id, MAX(time) AS last_time_uninstall
FROM logs.extension_uninstall
WHERE time>=(SELECT start_time FROM the_constants) AND time<=(SELECT end_time FROM the_constants)
GROUP BY 1,2
)
--deletion by developer is an implicit uninstall across all channels
, delete_logs AS (
SELECT extension_id, extension_version, MAX(time) AS last_time_delete
FROM logs.extension_delete
WHERE time>=(SELECT start_time FROM the_constants) AND time<=(SELECT end_time FROM the_constants)
GROUP BY 1,2
)
--join the logs
, the_logs AS (
SELECT base.extension_id, base.extension_version, base.user_id, base.last_time_install
, unin.last_time_uninstall, del.last_time_delete
FROM install_logs AS base
LEFT JOIN uninstall_logs AS unin ON base.extension_id = unin.extension_id AND base.user_id = unin.user_id
LEFT JOIN delete_logs AS del ON base.extension_id = del.extension_id AND base.extension_version=del.extension_version
)
, the_logs_final AS (
SELECT *
, CASE
WHEN last_time_install IS NULL THEN 0  --if no install timestamp then can't be installed
WHEN last_time_uninstall >= last_time_install AND last_time_uninstall IS NOT NULL THEN 0
WHEN last_time_delete >= last_time_install AND last_time_delete IS NOT NULL THEN 0
ELSE 1 END AS flag_is_installed
FROM the_logs
)


SELECT end_time AS the_time, 'net_installs' AS metric_name, base.*
FROM (
  SELECT
  COUNT(DISTINCT user_id) AS channels
  , COUNT(1) AS installed_extensions
  , COUNT(1)::float / COUNT(DISTINCT user_id)::float AS extensions_per_channel
  FROM the_logs_final
  WHERE flag_is_installed=1
) AS base
LEFT JOIN the_constants ON 1=1
