-- by yanghung
-- generate list of channels along with their partner/affiliate status
DROP TABLE IF EXISTS    analysis.dsds170_dedicated_streamer_list_2017_11;
CREATE TABLE    analysis.dsds170_dedicated_streamer_list_2017_11    AS


WITH
the_constants AS (
  SELECT '2017-11-01'::TIMESTAMP AS analysis_date --choose the date you want to pull dedicated streamer list for
)
, the_time_constants AS (
  SELECT
    date::TIMESTAMP AS the_date
    , date::TIMESTAMP - INTERVAL '29 days' AS start_time_rolling_30 --Greater Than Equal To (>=) this timestamp
    , date::TIMESTAMP + INTERVAL '1 days' - INTERVAL '0 seconds' AS end_time_rolling_30 -- Less Than (<) this timestamp
    , DATEDIFF('hours', date::TIMESTAMP - INTERVAL '29 days', date::TIMESTAMP + INTERVAL '1 days' - INTERVAL '0 seconds')::float/24 AS the_days_difference
  FROM metadata.date
  WHERE date=(SELECT analysis_date FROM the_constants)
)
, list_dedicated_streamer AS (
  SELECT *
  FROM (
    SELECT tc.the_date, cc.channel_id, SUM(1)::float / 30 AS mb_per_day
    FROM logs.channel_concurrents AS cc
    LEFT JOIN the_time_constants AS tc ON 1=1
    WHERE time>=(SELECT start_time_rolling_30 FROM the_time_constants) AND time<(SELECT end_time_rolling_30 FROM the_time_constants)
    GROUP BY 1,2
  )
  WHERE mb_per_day>=10
)
SELECT * FROM list_dedicated_streamer
