-- We need your query and logic for calculating the matrix below.
-- Date
-- ExtensionID/Name
-- Net installs
-- Net activates
-- Daily total views
-- Daily unique viewers
-- Daily unique interactors
-- Daily clicks
-- Daily clicks per interactor
-- Interaction Rate


WITH
the_constants AS (
  SELECT '2017-09-06'::TIMESTAMP AS start_time --extensions officially entered preview on this date
  , DATE_TRUNC('day', (SYSDATE - INTERVAL '7 hours'))::TIMESTAMP AS end_time --do not pull today's data since it is not fully loaded in db
)
--exclude these events as they are not coming from the viewer watching a channel page
, extension_mode_exclude AS (
    SELECT 'dashboard' AS extension_mode
    UNION ALL SELECT 'config' AS extension_mode
)

, metric_net_installs AS (
  SELECT the_day::TIMESTAMP, extension_id, COUNT(DISTINCT channel_id) AS net_installs
  FROM rollups.extension_daily_channel_presence
  WHERE the_day>=(SELECT start_time FROM the_constants) AND the_day<(SELECT end_time FROM the_constants)
  AND bool_extension_installed
  --AND extension_id ='4ntuott0zqw008atk0wy60phfa8jyf' -- hearthstone interactive overlay
  GROUP BY 1,2
)

, metric_net_activates AS (
  SELECT the_day::TIMESTAMP, extension_id, COUNT(DISTINCT channel_id) AS net_activates
  FROM rollups.extension_daily_channel_presence
  WHERE the_day>=(SELECT start_time FROM the_constants) AND the_day<(SELECT end_time FROM the_constants)
  AND bool_extension_activated
  --AND extension_id ='4ntuott0zqw008atk0wy60phfa8jyf' -- hearthstone interactive overlay
  GROUP BY 1,2
)

--a render event for video_overlay is an implicit view event
, metric_total_views_video_overlay AS (
  SELECT DATE_TRUNC('day', base.time) AS the_day, extension_id, COUNT(1) AS total_views
  FROM logs.extension_render AS base
  WHERE base.time>=(SELECT start_time FROM the_constants) AND base.time<(SELECT end_time FROM the_constants)
  AND base.extension_mode NOT IN (SELECT extension_mode FROM extension_mode_exclude) --make sure this is event from viewer watching channel page only
  AND base.extension_anchor = 'video_overlay'
  --AND extension_id ='4ntuott0zqw008atk0wy60phfa8jyf' -- hearthstone interactive overlay
  GROUP BY 1,2
)
--for panel extension, it must be at least 75% visible to count as a view event
, metric_total_views_panel AS (
  SELECT DATE_TRUNC('day', base.time) AS the_day, extension_id, COUNT(1) AS total_views
  FROM logs.extension_view AS base
  WHERE base.time>=(SELECT start_time FROM the_constants) AND base.time<(SELECT end_time FROM the_constants)
  AND base.extension_mode NOT IN (SELECT extension_mode FROM extension_mode_exclude) --make sure this is event from viewer watching channel page only
  AND base.extension_anchor = 'panel'
  AND base.pct_view_visible>=75 --at least 75% visible to count as a view
  --AND extension_id ='4ntuott0zqw008atk0wy60phfa8jyf' -- hearthstone interactive overlay
  GROUP BY 1,2
)
, metric_total_views AS (
  SELECT * FROM metric_total_views_video_overlay
  UNION ALL SELECT * FROM metric_total_views_panel
)
, metric_unique_viewers_interactors AS (
  SELECT the_day, extension_id, unique_devices_view AS unique_viewers, unique_devices_click AS unique_interactors
  FROM rollups.extension_daily_stats_non_version
  WHERE the_day>=(SELECT start_time FROM the_constants) AND the_day<(SELECT end_time FROM the_constants)
  --AND extension_id ='4ntuott0zqw008atk0wy60phfa8jyf' -- hearthstone interactive overlay
)
, metric_total_clicks AS (
  SELECT DATE_TRUNC('day', base.time) AS the_day, extension_id, COUNT(1) AS total_clicks
  FROM logs.extension_click AS base
  WHERE base.time>=(SELECT start_time FROM the_constants) AND base.time<(SELECT end_time FROM the_constants)
  AND base.extension_mode NOT IN (SELECT extension_mode FROM extension_mode_exclude)
  AND base.extension_anchor IN ('panel', 'video_overlay')
  --AND extension_id ='4ntuott0zqw008atk0wy60phfa8jyf' -- hearthstone interactive overlay
  GROUP BY 1,2
)


, final_data AS (
  SELECT mni.the_day, mni.extension_id, mni.net_installs
  , mna.net_activates
  , mtv.total_views
  , muvi.unique_viewers, muvi.unique_interactors
  , mtc.total_clicks
  , mtc.total_clicks::FLOAT / muvi.unique_interactors::FLOAT AS clicks_per_interactor
  , muvi.unique_interactors::FLOAT / muvi.unique_viewers::FLOAT AS interaction_rate
  FROM metric_net_installs AS mni
  LEFT JOIN metric_net_activates AS mna ON mni.the_day = mna.the_day AND mni.extension_id = mna.extension_id
  LEFT JOIN metric_total_views AS mtv ON mni.the_day = mtv.the_day AND mni.extension_id = mtv.extension_id
  LEFT JOIN metric_unique_viewers_interactors AS muvi ON mni.the_day = muvi.the_day AND mni.extension_id = muvi.extension_id
  LEFT JOIN metric_total_clicks AS mtc ON mni.the_day = mtc.the_day AND mni.extension_id = mtc.extension_id
)

SELECT * FROM final_data
--ORDER BY extension_id, the_day
