-- https://blueprint.twitch.tv/#/schema/ingest_stream_start
-- aggregated along resolutions at ingest by day. So something like
--
-- the_day              video_height    video_width      aspect_ratio     num_unique_streamers
-- 2018-01-01              1080                 1920                  16:9                  44560
-- 2018-01-01               720                 1280                   16:9                  63221
-- 2018-01-02              1080                 1920                  16:9                  24443
-- 2018-01-02               720                 1280                   16:9                  83747

WITH
the_constants AS (
  SELECT '2017-11-01 00:00:00' AS start_time
  , '2018-02-27 00:00:00' AS end_time
)

, final_data AS (
  SELECT DATE_TRUNC('day', time) AS the_day, video_height, video_width, COUNT(DISTINCT channel_id) AS num_unique_streamers
  FROM logs.ingest_stream_start
  WHERE time>=(SELECT start_time FROM the_constants)
  AND time<(SELECT end_time FROM the_constants)
  GROUP BY 1,2,3
  ORDER BY 1,2,3
)

SELECT *
FROM final_data
--
--
-- SELECT DISTINCT video_width, video_height FROM final_data WHERE num_unique_streamers>1000
-- ORDER BY 1,2
