#!/usr/bin/env python3
import base64
import json
import requests

event = {
  'event': 'extension_render',
  'properties': {
    'login': 'user_login',
    'channel': 'channel_name',
    'language': 'en',
    'custom_field': 'custom_value'
  }
}
event_json = json.dumps(event, separators=(',', ':'))
the_json = bytes(event_json, 'utf-8')
encoded_event = base64.b64encode(the_json)

r = requests.post('https://spade-echo.internal.justin.tv/track', data=encoded_event)
print(r.status_code)
