
with

jax_live_log AS (
  select channels.rails_channel_id as channel, games.name AS name, 1 AS mins_streamed
  from logs.jax_live_channel as channels
  join db_snapshots.games as games
  on channels.rails_game_id = games.id
  --where games.name = '{{ game_name }}' and time >= '{{ start_date }}'::timestamp and time < '{{ end_date }}'::timestamp
  WHERE time >= '{{ start_date }}'::timestamp and time < '{{ end_date }}'::timestamp
),

hours_streamed as
(select sum(mins_streamed) as hours, channel
from jax_live_log
group by channel
),

hours_streamed_game as
(select sum(mins_streamed) as hours, channel
from jax_live_log
where name = '{{ game_name }}'
group by channel
),


hours_ratio as
  (select base.hours/hs.hours::float as ratio, base.channel
  from hours_streamed_game as base
  join hours_streamed as hs
  on base.channel = hs.channel
),

extension_users as
(select distinct channel_id as channel, rel.extension_name  as extension
from rollups.extension_daily_channel_presence as base
join analysis.released_extensions_latest as rel
on base.extension_id = rel.extension_id
where the_day >= '{{ start_date }}'::timestamp and the_day < '{{ end_date }}'::timestamp and rel.extension_name = '{{ extension_name }}' and bool_extension_activated = TRUE
),

final_users as
(select base.ratio, base.channel,
        case
          when eu.extension is null then 0
          else 1
          end as bool_extension_used
from hours_ratio as base
left join extension_users as eu
on base.channel = eu.channel
where base.ratio >= 0.5
),

-- test cases for extension_used
-- 83606828 - 1
-- 7719747 - 0


teir_classification as
( select fu.channel as channel,
         case
          when avg(total::float) <= 2 then 'T0: 0-2 ccu'
          when avg(total::float) <= 25 then 'T1: 3-25 ccu'
          when avg(total::float) <= 200 then  'T2: 26-200 ccu'
          when avg(total::float) <= 2000 then  'T3: 201-2000 ccu'
          when avg(total::float) > 2000 then  'T4: 2001+ ccu'
         else 'Unknown'
         end as tier, fu.bool_extension_used as extn
  from logs.channel_concurrents as base
  join final_users as fu
  on base.channel_id = fu.channel
  where time >= '{{ start_date }}'::timestamp and time < '{{ end_date }}'::timestamp
  group by 1,fu.bool_extension_used
),

foo as
(select tier, count(1) as users, sum(extn) as extension_users
from teir_classification
group by 1
)

select *, (extension_users::float * 100/users) as percent_using_extension
from foo
ORDER BY 1


-- select tier, channel,
--       case
--         when
-- from teir_classification


{% form %}

start_date:
  type: text
  default: '2017-10-01 00:00:00'

end_date:
  type: text
  default: '2017-10-31 00:00:00'

game_name:
  type: text
  default: 'Destiny 2'

{% endform %}
