

WITH

the_constants AS (
  SELECT '2018-02-25'::TIMESTAMP AS start_time, '2018-03-01'::TIMESTAMP AS end_time
)

, list_extensions_mgr_viewers AS (
  SELECT "time", user_id, SPLIT_PART(url,'/',4) as channel_name, url
  FROM logs.pageview
  WHERE
  url LIKE 'https://www.twitch.tv/%/dashboard/extensions%'
  --user_id=154499793
  AND time>=(SELECT start_time FROM the_constants) AND time<(SELECT end_time FROM the_constants)
  AND user_id IS NOT NULL
)


SELECT *
FROM list_extensions_mgr_viewers
ORDER BY 1,2
