--Released Extensions row 9
--https://docs.google.com/spreadsheets/d/1sxkI3v3w5dh4VhbE9ur14ys-iLAsALcg-Fp10VA3igA/edit?ts=5a399fb0#gid=246267467

WITH

the_time_constants AS (
  SELECT DATE_TRUNC('month', (SYSDATE - INTERVAL '7 hours')) AS end_date
)



, the_basetable_date AS (
  SELECT
    DATE_TRUNC('month', date) AS the_month, MIN(date) AS start_date, MAX(date) AS end_date
  FROM metadata.date
  WHERE date>='2017-10-01' AND date<(SELECT end_date FROM the_time_constants)
  GROUP BY 1
)
, extension_daily_channel_presence_log AS (
  SELECT dcp.the_day, dcp.extension_id, COUNT(DISTINCT dcp.channel_id) AS channels
  FROM rollups.extension_daily_channel_presence AS dcp
  RIGHT JOIN analysis.released_extensions_latest AS rel ON dcp.extension_id = rel.extension_id
  WHERE  the_day IN (SELECT end_date FROM the_basetable_date)
  GROUP BY 1,2
)
SELECT *
FROM (
  SELECT base.the_month, base.start_date, base.end_date, COUNT(DISTINCT dcp.extension_id) AS released_extensions
  FROM the_basetable_date AS base
  LEFT JOIN extension_daily_channel_presence_log AS dcp ON base.end_date=dcp.the_day
  GROUP BY 1,2,3
)
WHERE the_month IS NOT NULL
ORDER BY 1,2,3
