-- Purchasers row 21
-- ARPPU row 22
--https://docs.google.com/spreadsheets/d/1sxkI3v3w5dh4VhbE9ur14ys-iLAsALcg-Fp10VA3igA/edit?ts=5a399fb0#gid=246267467


WITH

the_time_constants AS (
  SELECT DATE_TRUNC('month', (SYSDATE - INTERVAL '7 hours')) AS end_date
)



, the_basetable_date AS (
  SELECT
    DATE_TRUNC('month', date) AS the_month, MIN(date) AS start_date, MAX(date) AS end_date
  FROM metadata.date
  WHERE date>='2017-10-01' AND date<(SELECT end_date FROM the_time_constants)
  GROUP BY 1
)
SELECT base.the_month, base.start_date, base.end_date, COUNT(DISTINCT eie.user_id) AS num_purchasers, SUM(eie.purchase_value)::FLOAT/COUNT(DISTINCT eie.user_id)::FLOAT AS arppu
FROM the_basetable_date AS base
LEFT JOIN logs.extension_item_entitled AS eie ON base.start_date<=eie.time AND eie.time<base.end_date + INTERVAL '1 day'
GROUP BY 1,2,3
ORDER BY 1,2,3
