WITH

the_constants_time AS (
  SELECT * FROM analysis.dsds190_mbr_timeframe
  WHERE start_time>=DATE_TRUNC('month', '2018-04-22'::TIMESTAMP) -- this was the sunday when bits in extension "launched"
  AND end_time<DATE_TRUNC('day', (SYSDATE - INTERVAL '7 hours')) --only select up to the current date
)


, extension_render_log AS (
  SELECT base.time, base.extension_id, rel.extension_name
  FROM tahoe.extension_render AS base
  RIGHT JOIN analysis.released_extensions_latest AS rel ON base.extension_id = rel.extension_id
  WHERE base.time>=(SELECT MIN(start_time) FROM the_constants_time)
  AND base.time<=(SELECT MAX(end_time) FROM the_constants_time)
  AND rel.is_bits_enabled = TRUE
)


, final_data AS (
  SELECT base.year, base.month, base.start_time, base.end_time, COUNT(DISTINCT er.extension_id) AS extensions_with_bits_enabled
  FROM the_constants_time AS base
  LEFT JOIN extension_render_log AS er ON base.start_time <= er.time AND er.time <= base.end_time
  GROUP BY 1,2,3,4
)

SELECT * FROM final_data
ORDER BY 1,2
