WITH

the_constants_time AS (
  SELECT * FROM analysis.dsds190_mbr_timeframe
  WHERE start_time>=DATE_TRUNC('month', '2018-04-22'::TIMESTAMP) -- this was the sunday when bits in extension "launched"
  AND end_time<DATE_TRUNC('day', (SYSDATE - INTERVAL '7 hours')) --only select up to the current date
)

, extension_daily_channel_presence_log AS (
  SELECT base.the_day, base.channel_id, base.extension_id
  FROM rollups.extension_daily_channel_presence AS base
  INNER JOIN analysis.released_extensions_latest AS rel ON base.extension_id = rel.extension_id
  WHERE base.the_day IN (SELECT join_key_end_date FROM the_constants_time)
  AND base.bool_extension_activated = TRUE
  AND rel.is_bits_enabled = TRUE
  GROUP BY 1,2,3
)

, dedicated_streamer_log AS (
  SELECT base.the_date AS the_day, base.channel_id
  FROM analysis.dsds158_dedicated_channel_list AS base
  WHERE base.the_date IN (SELECT join_key_end_date FROM the_constants_time)
  GROUP BY 1,2
)

, joined_data AS (
  SELECT base.the_day, base.channel_id, base.extension_id
  FROM extension_daily_channel_presence_log AS base
  INNER JOIN dedicated_streamer_log AS ded ON base.the_day = ded.the_day AND base.channel_id = ded.channel_id
)

, extension_render_log AS (
  SELECT base.time, base.device_id, base.channel_id
  FROM tahoe.extension_render AS base
  INNER JOIN analysis.released_extensions_latest AS rel ON base.extension_id = rel.extension_id
  WHERE base.time>=(SELECT MIN(start_time) FROM the_constants_time)
  AND base.time<=(SELECT MAX(end_time) FROM the_constants_time)
  AND base.channel_id IN (SELECT DISTINCT channel_id FROM joined_data)
  AND rel.is_bits_enabled = TRUE
)

, final_data AS (
  SELECT base.year, base.month, base.start_time, base.end_time, COUNT(DISTINCT er.device_id) AS devices_in_dedicated_channels_with_bits_extensions
  FROM the_constants_time AS base
  LEFT JOIN extension_render_log AS er ON base.start_time <= er.time AND er.time <= base.end_time
  GROUP BY 1,2,3,4
)

SELECT * FROM final_data
ORDER BY 1,2
