DROP TABLE IF EXISTS    analysis.dsds238_viewer_id_lookup;
CREATE TABLE    analysis.dsds238_viewer_id_lookup    AS

WITH

time_constants AS (
  SELECT '2017-09-01' AS start_time, '2018-04-25' AS end_time
)
, viewer_lookup AS (
  SELECT device_id, user_id, viewer_id
  FROM rollups.daily_viewers
  WHERE day>=(SELECT start_time FROM time_constants) AND day<(SELECT end_time FROM time_constants)
  AND viewer_id != 0
  GROUP BY 1,2,3
)

SELECT * FROM viewer_lookup;
