DROP TABLE IF EXISTS    analysis.dsds238_monthly_extension_channels;
CREATE TABLE    analysis.dsds238_monthly_extension_channels    AS

WITH

time_constants AS (
  SELECT '2018-01-01'::TIMESTAMP AS the_month, '2018-01-31'::TIMESTAMP AS join_key_the_day
  UNION ALL SELECT '2018-02-01'::TIMESTAMP AS the_month, '2018-02-28'::TIMESTAMP AS join_key_the_day
  UNION ALL SELECT '2018-03-01'::TIMESTAMP AS the_month, '2018-03-31'::TIMESTAMP AS join_key_the_day
)

, extensions_channel_data AS (
  SELECT edcp.the_day, edcp.extension_id, edcp.channel_id
  FROM rollups.extension_daily_channel_presence AS edcp
  RIGHT JOIN analysis.released_extensions_latest AS rel ON edcp.extension_id = rel.extension_id
  WHERE edcp.bool_extension_activated IS TRUE
  AND edcp.the_day IN (SELECT join_key_the_day FROM time_constants)
)

, final_data AS (
  SELECT base.the_month, edcp.extension_id, edcp.channel_id
  FROM time_constants AS base
  LEFT JOIN extensions_channel_data AS edcp ON base.join_key_the_day = edcp.the_day
)

SELECT * FROM final_data
